//----------------------------------*-C++-*----------------------------------//
// slist.cc
// Geoffrey Furnish
// 16 January 1994
//---------------------------------------------------------------------------//
// @> Stroustrup's slist family (2nd ed, chapter 8).
//
// $Id: slist.cc,v 1.2 1995/09/16 17:04:14 furnish Exp $
//
// $Log: slist.cc,v $
// Revision 1.2  1995/09/16  17:04:14  furnish
// Convert all list variants away from auto-incrementation behavior, and
// standardize on the explicit increment mode which was already in use
// with the SPlist.  All DS++ list and map classes now support uniform
// naming and operation conventions.
//
// Revision 1.1  1994/02/01  19:22:33  furnish
// Stroustrup's slist helper classes for Islist and Slist.
//
//---------------------------------------------------------------------------//

#include "slist.h"

#include <iostream.h>

//===========================================================================//
// class slist_base - Base class for all singly linked lists

// This class serves as the link maintainer for the singly linked list
// variants. 
//===========================================================================//

//---------------------------------------------------------------------------//
// Insert a new item at the head of the list.
//---------------------------------------------------------------------------//

void slist_base::insert( slink *a )
{
    if (last)
	a->next = last->next;
    else
	last = a;
    last->next = a;
}

//---------------------------------------------------------------------------//
// Append a new item to the tail of the list.
//---------------------------------------------------------------------------//

void slist_base::append( slink *a )
{
    if (last) {
	a->next = last->next;
	last = last->next = a;
    } else
	last = a->next = a;
}

//---------------------------------------------------------------------------//
// This method removes and returns the head element of the list.  I am having
// a hard time seeing why we would want a method which does exactly this.
// Probably a better idea would be to have a list iterator which could chop
// an element right out of the middle of the list.  Have to look into that
// someday. 
//---------------------------------------------------------------------------//

slink *slist_base::get()
{
    if (last==0) {
	cerr << "slist_base::get() : Get from empty list!\n" << flush;
	return 0;
    }

    slink *f = last->next;
    if (f==last)
	last = 0;
    else
	last->next = f->next;
    return f;
}

//---------------------------------------------------------------------------//
//                              end of slist.cc
//---------------------------------------------------------------------------//
