//----------------------------------*-C++-*----------------------------------//
// SArray.h
// Geoffrey Furnish
// Tue Dec 27 21:45:18 1994
//---------------------------------------------------------------------------//
// @> A "simple" array class.
//
// $Id: SArray.h,v 1.3 1995/11/11 01:51:08 furnish Exp $
//
// $Log: SArray.h,v $
// Revision 1.3  1995/11/11  01:51:08  furnish
// Little nitty template specification errors detected by IBM xlC, but
// missed by every other compiler I've used to date.
//
// Revision 1.2  1995/08/28  20:45:44  furnish
// Support redimensioning an SArray<T>.
//
// Revision 1.1  1994/12/29  16:14:56  furnish
// A new templated "simple" array class, since Array<T> not appropriate
// in all situations due to template instantiation brain damage on the
// part of several major compilers.
//
//---------------------------------------------------------------------------//

#ifndef __SArray_h__
#define __SArray_h__

#include "Assert.h"

//===========================================================================//
// class SArray<T> - A "simple" array class

// This class is intended to implement the simplest form of a bounds checked
// array class.  It should be used in cases where the templated type parameter
// does not support the vast array of operators required by the sister
// Array<T> class.  Unfortunately, neither Cfront nor GCC currently follow the
// rules for demand driven template method instantiation which are described
// in the literature, so the Array class has proven to be untennable for some
// template type parameters.  This one should serve in it's place.
//===========================================================================//

template<class T>
class SArray {

    T *v;
    int sz;

  public:
    SArray( int _sz =0 );
    SArray( const SArray<T>& s );
    ~SArray();
    SArray<T>& operator=( const SArray<T>& s );

    int size() const { return sz; }

    void redim( int nsz );

    T  operator[]( int n ) const
    {
	Assert( n >= 0 && n < sz );

	return v[n];
    }

    T& operator[]( int n )
    {
	Assert( n >= 0 && n < sz );

	return v[n];
    }
};

#endif                          // __SArray_h__

//---------------------------------------------------------------------------//
//                              end of SArray.h
//---------------------------------------------------------------------------//
