//----------------------------------*-C++-*----------------------------------//
// SArray.cc
// Geoffrey Furnish
// Tue Dec 27 21:45:19 1994
//---------------------------------------------------------------------------//
// @> A "simple" array class.
//
// $Id: SArray.cc,v 1.4 1995/09/04 15:54:20 furnish Exp $
//
// $Log: SArray.cc,v $
// Revision 1.4  1995/09/04  15:54:20  furnish
// Stupid typo in last commit.
//
// Revision 1.3  1995/09/04  15:51:29  furnish
// SGI C++ operator new is hosed.  Grrrrr.
//
// Revision 1.2  1995/08/28  20:45:41  furnish
// Support redimensioning an SArray<T>.
//
// Revision 1.1  1994/12/29  16:14:55  furnish
// A new templated "simple" array class, since Array<T> not appropriate
// in all situations due to template instantiation brain damage on the
// part of several major compilers.
//
//---------------------------------------------------------------------------//

#include "SArray.h"

//---------------------------------------------------------------------------//
// Construcor.  Specify the size of the array.
//---------------------------------------------------------------------------//

template<class T>
SArray<T>::SArray( int _sz /*=0*/ )
    : sz(_sz)
{
#ifdef __sgi
    if (sz == 0)
	sz = 1;
#endif
    v = new T[ sz ];
}

//---------------------------------------------------------------------------//
// Copy constructor.
//---------------------------------------------------------------------------//

template<class T>
SArray<T>::SArray( const SArray<T>& s )
{
    sz = s.sz;
    v = new T[ sz ];

    for( int i=0; i < sz; i++ )
	v[i] = s.v[i];
}

//---------------------------------------------------------------------------//
// Destructor.  Make sure we clean up after ourselves.
//---------------------------------------------------------------------------//

template<class T>
SArray<T>::~SArray()
{
    delete[] v;
}

//---------------------------------------------------------------------------//
// Assignment operator.
//---------------------------------------------------------------------------//

template<class T>
SArray<T>& SArray<T>::operator=( const SArray<T>& s )
{
    if (this == &s) return *this;	// "It can happen."

    delete[] v;

    sz = s.sz;
    v = new T[ sz ];

    for( int i=0; i < sz; i++ )
	v[i] = s.v[i];

    return *this;
}

//---------------------------------------------------------------------------//
// Change the size of the container.
//---------------------------------------------------------------------------//

template<class T>
void SArray<T>::redim( int nsz )
{
    delete[] v;
    sz = nsz;
    v = new T[ sz ];
}

//---------------------------------------------------------------------------//
//                              end of SArray.cc
//---------------------------------------------------------------------------//

