//----------------------------------*-C++-*----------------------------------//
// DynTable.h
// Geoffrey Furnish
// Tue Jan 24 11:44:14 1995
//---------------------------------------------------------------------------//
// @> An autoexpanding row/col container class.
//
// $Id: DynTable.h,v 1.2 1995/07/20 17:25:00 lindberg Exp $
//
// $Log: DynTable.h,v $
// Revision 1.2  1995/07/20  17:25:00  lindberg
// Expanded DynTable that incorporates added methods that will be used by
// tracer.
//
// Revision 1.1  1995/01/24  18:31:54  furnish
// New templated class for handling dynamic tables of data.
//
//---------------------------------------------------------------------------//

#ifndef __DynTable_h__
#define __DynTable_h__

#include "DynArray.h"

//===========================================================================//
// class DynTable<T> - An autoexpanding row/column container

// This class provides a very crude table facility.  Essentially it provides a
// two dimensional storage facility, somewhat like a matrix in terms of its
// syntax, but the internal storage mechanism is totally different.  This
// table supports arbitrary expansion of the number of rows, and of the number
// of columns within a row.  The rows are independent, expanding the number of
// columns in one row does not affect the number of columns in any other row.
//
// USAGE:
// One way to use this (and the reason for which it was cobbled together) is
// as a replacement for "pointers to pointers".  Instead of "char **", you can
// now use "DynTable<char>".  This should be much safer than pointers to
// pointers, and also much easier to control in terms of memory footprint.  
// That is to say, /no/ work is required on the part of the user to get access
// to more storage, or to free storage when done.  The autoexapnding methods
// and the destructor take care of all that grunge.
//
// ISSUES:
// This is a crude class.  Just thrown together AFAP.  It should have useful
// methods for querrying its state, for explicit operations (add row, etc),
// ways to delete rows/columns, suggested sizing, specifiable expansion data
// fill, etc.  All of these issues are on hold for the time being.  Also, some
// form of integrity checking should be available--exporting a reference is
// dangerous.  Someone could do a bcopy and wreck the entire memory system.
// Of course that could happen irrespective of this class, so that per se is
// not a failing of this class, but it would be good to be able to at least
// recognize such violations.
//===========================================================================//

template<class T>
class DynTable {

    DynArray<DynArray<T> > data;

  public:

    T& operator()( int row, int col );
    T  operator()( int row, int col ) const;

    int low_row()  const { return data.low(); }
    int high_row() const { return data.high(); }
    int low_column ( int row ) const { return data[row].low(); }
    int high_column( int row ) const { return data[row].high(); }

    void delete_row( int row );
    void del_col_range( int row, int begin_col, int end_col );

};

#endif                          // __DynTable_h__

//---------------------------------------------------------------------------//
//                              end of DynTable.h
//---------------------------------------------------------------------------//
