//----------------------------------*-C++-*----------------------------------//
// tDynArraySwap.cc
// Geoffrey Furnish
// Tue Jan 24 16:39:21 1995
//---------------------------------------------------------------------------//
// @> Test program for DynArraySwap<T>.
//
// $Id: tDynArraySwap.cc,v 1.1 1995/01/27 19:28:53 furnish Exp $
//
// $Log: tDynArraySwap.cc,v $
// Revision 1.1  1995/01/27  19:28:53  furnish
// New class for point to point transmission of DS++ DynArray's.
//
//---------------------------------------------------------------------------//

#include <iostream.h>

#include "c4/global.h"
#include "c4/DynArraySwap.h"
#include "c4/DeepBSwap.h"

//---------------------------------------------------------------------------//
// This program constructs an DynArray on one node, and transfers it to
// another. This tests the DeepBSwap class, the DeepObj class, and the
// DynArraySwap class.
//---------------------------------------------------------------------------//

int main( int argc, char *argv[] )
{
    ios::sync_with_stdio();

    C4_Init( argc, argv );
    int node = C4_node();

    cout << "Hello from node " << node << endl;

    C4_gsync();

    if (!C4_node()) {
	DynArray<int> a(10);

	for( int i=0; i < 10; i++ )
	    a[i] = i;

	DynArraySwap<int> asw( a );
	DeepBSwap right( 1 );
	right.send( asw );
    }

    if (C4_node() == 1) {
	DynArray<int> a;
	a = 0;

	DynArraySwap<int> asw( a );
	DeepBSwap left( 0 );
	left.recv(asw);

	for( int i=0; i < a.Get_size(); i++ )
	    cout << "a[" << i << "] = " << a[i] << endl;
    }

    C4_gsync();
    cout << "Node " << node << " ready to terminate.\n";

    C4_Finalize();
    return 0;
}

//---------------------------------------------------------------------------//
//                              end of tDynArraySwap.cc
//---------------------------------------------------------------------------//

