//----------------------------------*-C++-*----------------------------------//
// tDstArray.cc
// Maurice LeBrun
// Wed Mar 25 1995
//---------------------------------------------------------------------------//
// @> Test case for the DstArray class.
//
// $Id: tDstArray.cc,v 1.2 1995/03/30 08:23:56 mjl Exp $
//
// $Log: tDstArray.cc,v $
// Revision 1.2  1995/03/30  08:23:56  mjl
// Tweaks.
//
// Revision 1.1  1995/03/27  19:54:58  mjl
// Test program for checking the DstArray class.
//
//---------------------------------------------------------------------------//

#include "c4/DstArray.h"
#include "c4/SpinLock.h"

#include <stdlib.h>
#include <iostream.h>

int node, nodes;
int ncu = 32;

void
test_Array_to_DstArray();

//---------------------------------------------------------------------------//
// Tests DstArray class.
//---------------------------------------------------------------------------//

int main( int argc, char *argv[] )
{
    ios::sync_with_stdio();

    C4_Init( argc, argv );

// Find out who we are.

    node = C4_node();
    nodes = C4_nodes();

// Run tests

    test_Array_to_DstArray();

    C4_Finalize();
    return 0;
}

//---------------------------------------------------------------------------//
// Test assignment from a wide Array to a DstArray
//---------------------------------------------------------------------------//

void
test_Array_to_DstArray()
{
// Declare a wide array and fill it.

    Array<float> a(ncu);

    for (int i = 0; i < ncu; i++)
	a[i] = i;

// Declare a DstArray of size ncu/nodes.
// The offset defaults to node*size, although it can be specified as the
// second argument to the constructor.

    int size = ncu/nodes;
#if 1
    DstArray<float> b(size);
#else
    int offset = node*size;
    DstArray<float> b(size, offset);
#endif

// Assign it and print the result.

    b = a;

    {
	HTSyncSpinLock s;
	cout << "Node " << node << ": ";
	for (i = 0; i < size; i++)
	    cout << " " << b[i];
	cout << endl;
    }
}

//---------------------------------------------------------------------------//
//                              end of tDstArray.cc
//---------------------------------------------------------------------------//
