//----------------------------------*-C++-*----------------------------------//
// tBSwap.cc
// Geoffrey Furnish
// Wed Jan 18 13:39:39 1995
//---------------------------------------------------------------------------//
// @> Test program for BSwap<T>.
//
// $Id: tBSwap.cc,v 1.2 1995/01/23 19:57:08 furnish Exp $
//
// $Log: tBSwap.cc,v $
// Revision 1.2  1995/01/23  19:57:08  furnish
// Explicit template instantiation support.
//
// Revision 1.1  1995/01/18  21:02:57  furnish
// Test program for BSwap, and implementation on MPI.
//
//---------------------------------------------------------------------------//

#include "c4/global.h"
#include "c4/NodeInfo.h"
#include "c4/BSwap.h"

#include <iostream.h>

#ifdef __GNUC__
#include "c4/BSwap.cc"
template class BSwap<int>;
#endif

//---------------------------------------------------------------------------//
// This program demonstrates the use of the BSwap<T> class by passing an
// integer across all the nodes, doing a little work on it each time.  This is
// a very trivial example, but should be sufficient to test the class.
//---------------------------------------------------------------------------//

int main( int argc, char *argv[] )
{
    C4_Init( argc, argv );

    int node = C4_node();
    int nodes = C4_nodes();

    cout << "Hello from " << node << endl;

    if (node) {
	int i;
	BSwap<int> left( node-1 );
	left.recv(i);
	i *= 2;
	if (node < nodes-1) {
	    BSwap<int> right( node+1 );
	    right.send(i);
	} else {
	    cout << "2 to the " << nodes << " power is " << i << endl;
	}

    } else {
	int i=2;
	if (nodes > 1) {
	    BSwap<int> right( 1 );

	    right.send(i);
	} else
	    cout << "2 to the 1 power is " << i << endl;
    }

    C4_gsync();
    C4_Finalize();
    return 0;
}

//---------------------------------------------------------------------------//
//                              end of tBSwap.cc
//---------------------------------------------------------------------------//

