//----------------------------------*-C++-*----------------------------------//
// tArraySwap.cc
// Geoffrey Furnish
// Tue Jan 24 16:39:21 1995
//---------------------------------------------------------------------------//
// @> Test program for ArraySwap<T>.
//
// $Id: tArraySwap.cc,v 1.1 1995/01/25 18:50:58 furnish Exp $
//
// $Log: tArraySwap.cc,v $
// Revision 1.1  1995/01/25  18:50:58  furnish
// Specialization of DeepObj for DS++ Array<T>.  With test case and
// template instantiation support.
//
//---------------------------------------------------------------------------//

#include <iostream.h>

#include "c4/global.h"
#include "c4/ArraySwap.h"
#include "c4/DeepBSwap.h"

//---------------------------------------------------------------------------//
// This program constructs an Array on one node, and transfers it to
// another. This tests the DeepBSwap class, the DeepObj class, and the
// ArraySwap class.
//---------------------------------------------------------------------------//

int main( int argc, char *argv[] )
{
    ios::sync_with_stdio();

    C4_Init( argc, argv );
    int node = C4_node();

    cout << "Hello from node " << node << endl;

    C4_gsync();

    if (!C4_node()) {
	Array<int> a(10);

	for( int i=0; i < 10; i++ )
	    a[i] = i;

	ArraySwap<int> asw( a );
	DeepBSwap right( 1 );
	right.send( asw );
    }

    if (C4_node() == 1) {
	Array<int> a;
	a = 0;

	ArraySwap<int> asw( a );
	DeepBSwap left( 0 );
	left.recv(asw);

	for( int i=0; i < a.size(); i++ )
	    cout << "a[" << i << "] = " << a[i] << endl;
    }

    C4_gsync();
    cout << "Node " << node << " ready to terminate.\n";

    C4_Finalize();
    return 0;
}

//---------------------------------------------------------------------------//
//                              end of tArraySwap.cc
//---------------------------------------------------------------------------//

