//----------------------------------*-C++-*----------------------------------//
// global.h
// Geoffrey Furnish
// Tue Dec 20 1994
//---------------------------------------------------------------------------//
// @> Improves on the NX API for global operations.
//
// $Id: global.h,v 1.9 1995/04/11 19:39:51 mjl Exp $
//
// $Log: global.h,v $
// Revision 1.9  1995/04/11  19:39:51  mjl
// Introduced some generic pass-left/pass-right enums.
//
// Revision 1.8  1995/03/15  18:49:15  furnish
// Improve ease of use by defaulting nonessential args, and by adding
// special purpose messaging calls for simple cases.
//
// Revision 1.7  1995/02/10  19:11:31  furnish
// Better support for scalar mode.
//
// Revision 1.6  1995/02/07  20:41:52  mjl
// Prototypes added for new global min/max functions.
//
// Revision 1.5  1995/02/01  20:47:51  furnish
// New C4 abstractions for blocking and non blocking messaging.
//
// Revision 1.4  1995/01/27  21:02:36  furnish
// Convert global reduction functions to have C4_ prefix.
//
// Revision 1.3  1995/01/18  20:24:27  furnish
// Added some global functions to provide staus info, implemented some
// MPI functionality, etc.
//
// Revision 1.2  1995/01/18  16:28:05  furnish
// Generalizations to support C4 objects on both NX and uniprocessor
// configurations.  MPI support yet to be added.
//
// Revision 1.1  1995/01/17  19:20:06  furnish
// NX global API improvements.  Needs to be generalized for C4.
//
//---------------------------------------------------------------------------//

#ifndef __global_h__
#define __global_h__

#include "c4/config.h"
#include "c4/C4_Req.h"

const int C4_SUCCESS = 0;
#ifdef __PARAGON__
const int C4_Any_Tag = -1;
const int C4_Any_Source = -1;
#endif
#ifdef __C4_SCALAR__
const int C4_Any_Tag = -1;
const int C4_Any_Source = -1;
#endif
#ifdef __MPI__
const int C4_Any_Tag = MPI_ANY_TAG;
const int C4_Any_Source = MPI_ANY_SOURCE;
#endif

const int C4_int_Tag = 432;

enum { C4_Pass_Left, C4_Pass_Right };

//---------------------------------------------------------------------------//
// Prototypes
// Cruft

void C4_Init( int& argc, char **& argv );
void C4_Finalize();

// Informational 

int C4_node();
int C4_nodes();
int C4_group();

// Global sync

void C4_gsync();

// Send/receive

int C4_Send( void *buf, int size, int dest, int tag, int group =0 );
int C4_Recv( void *buf, int size, int source, int tag, int group =0 );

C4_Req C4_SendAsync( void *buf, int size, int dest, int tag, int group =0 );
C4_Req C4_RecvAsync( void *buf, int size, int source, int tag, int group =0 );

// Super convenient special forms.

inline int C4_Send( int data, int dest, int group =0 )
{
    return C4_Send( &data, sizeof(int), dest, C4_int_Tag, group );
}

inline int C4_Recv( int& data, int source, int group =0 )
{
    return C4_Recv( &data, sizeof(int), source, C4_int_Tag, group );
}

// Global reductions
// Sum, scalar

void C4_gsum( int& x );
void C4_gsum( long& x );
void C4_gsum( float& x );
void C4_gsum( double& x );

// Sum, array

void C4_gsum( int *px, int n );
void C4_gsum( long *px, int n );
void C4_gsum( float *px, int n );
void C4_gsum( double *px, int n );

// Min, scalar

void C4_gmin( int& x );
void C4_gmin( long& x );
void C4_gmin( float& x );
void C4_gmin( double& x );

// Max, scalar

void C4_gmax( int& x );
void C4_gmax( long& x );
void C4_gmax( float& x );
void C4_gmax( double& x );

#endif                          // __global_h__

//---------------------------------------------------------------------------//
//                              end of global.h
//---------------------------------------------------------------------------//
