//----------------------------------*-C++-*----------------------------------//
// config.h
// Geoffrey Furnish
// Tue Jan 17 10:23:47 1995
//---------------------------------------------------------------------------//
// @> C4 master configuration header file.
//
// $Id: config.h,v 1.4 1995/02/01 20:47:14 furnish Exp $
//
// $Log: config.h,v $
// Revision 1.4  1995/02/01  20:47:14  furnish
// Slight improvement to autodetection logic.
//
// Revision 1.3  1995/01/23  22:43:27  mjl
// Added a SCALAR() macro for completeness.
//
// Revision 1.2  1995/01/18  20:23:02  furnish
// MPI recognition support.
//
// Revision 1.1  1995/01/17  19:21:44  furnish
// Master header file for C4.  Platform identification and configuration
// logic/support goes here.
//
//---------------------------------------------------------------------------//

#ifndef __c4_config_h__
#define __c4_config_h__

// Start by assuming we are running on a uniprocessor.

#define __C4_SCALAR__

// Now start checking for supported machines.  

// Currently, we assume if it's a Paragon, then they want to use NX.  Running
// MPI on a Paragon would require updating this logic.

#ifdef __PARAGON__
#undef __C4_SCALAR__
#include <nx.h>
#define PGN(a) a
#else
#define PGN(a)
#endif

// Handle MPI ...

#ifdef __LAM__
#define __MPI__
#endif

#ifdef __MPI__
#undef __C4_SCALAR__
#include <mpi.h>
#define MPI(a) a
#else
#define MPI(a)
#endif

// Add one for SCALAR for completeness

#ifdef __C4_SCALAR__
#define SCALAR(a) a
#else
#define SCALAR(a)
#endif

#endif                          // __c4_config_h__

//---------------------------------------------------------------------------//
//                              end of config.h
//---------------------------------------------------------------------------//
