//----------------------------------*-C++-*----------------------------------//
// Sync.h
// Maurice LeBrun
// Wed Jan 25 16:04:40 1995
//---------------------------------------------------------------------------//
// @> Classes for forcing a global sync at the head and/or tail of a block.
//
// $Id: Sync.h,v 1.1 1995/01/26 04:27:17 mjl Exp $
//
// $Log: Sync.h,v $
// Revision 1.1  1995/01/26  04:27:17  mjl
// Holds the global sync classes HSync, TSync, and HTSync.
//
//---------------------------------------------------------------------------//

#ifndef __Sync_h__
#define __Sync_h__

#include "c4/global.h"

//===========================================================================//
// class HSync - Head synchronizing

// Synchronizes processes at the head of a block by doing a global sync in
// the ctor.
//===========================================================================//

class HSync {

    HSync( const HSync& );
    HSync& operator=( const HSync& );

  public:
    HSync();
};

//===========================================================================//
// class TSync - Tail synchronizing

// Synchronizes processes at the tail of a block by doing a global sync in
// the dtor.
//===========================================================================//

class TSync {

    TSync( const TSync& );
    TSync& operator=( const TSync& );

  public:
    TSync() {};
    ~TSync();
};

//===========================================================================//
// class HTSync - Head & tail synchronizing

// Synchronizes processes at the head and tail of a block by doing a
// global sync in the ctor/dtor.
//===========================================================================//

class HTSync: public HSync, public TSync {

    HTSync( const HTSync& );
    HTSync& operator=( const HTSync& );

  public:
    HTSync() {};
};

#endif                          // __Sync_h__

//---------------------------------------------------------------------------//
//                              end of Sync.h
//---------------------------------------------------------------------------//
