//----------------------------------*-C++-*----------------------------------//
// SpinLock.h
// Geoffrey Furnish
// Fri Dec 16 13:29:01 1994
//---------------------------------------------------------------------------//
// @> A spin lock class.  Serializes execution of a blcok.
//
// $Id: SpinLock.h,v 1.5 1995/02/10 19:14:09 furnish Exp $
//
// $Log: SpinLock.h,v $
// Revision 1.5  1995/02/10  19:14:09  furnish
// Convenience macro.
//
// Revision 1.4  1995/02/01  20:48:22  furnish
// Convert from NX to generic C4 messaging calls.
//
// Revision 1.3  1995/01/26  04:26:23  mjl
// Added HSyncSpinLock, TSyncSpinLock, and HTSyncSpinLock classes.  All are
// obtained through multiple inheritance and require no additional code.
//
// Revision 1.2  1995/01/18  16:28:03  furnish
// Generalizations to support C4 objects on both NX and uniprocessor
// configurations.  MPI support yet to be added.
//
// Revision 1.1  1995/01/17  19:16:04  furnish
// Various types of spin locks.  Currently only work with NX.
//
//---------------------------------------------------------------------------//

#ifndef __SpinLock_h__
#define __SpinLock_h__

#include <stdio.h>

#include "c4/config.h"
#include "c4/NodeInfo.h"
#include "c4/Sync.h"

//===========================================================================//
// class SpinLock - Serialize execution of a block.

// This class enables you to get a block of code to execute serially.  Each
// processor begins to executes the block only after the one before it is
// finished.
//===========================================================================//

class SpinLock : public NodeInfo {

    SpinLock( const SpinLock& );
    SpinLock& operator=( const SpinLock& );

    enum { SL_Next = 92874 };

    int trash;

  public:
    SpinLock();
    ~SpinLock();
};

//===========================================================================//
// class HSyncSpinLock - Serialize a block, syncing at top.

// A spinlock that forces a global sync at the head of the block.
//===========================================================================//

class HSyncSpinLock : public HSync, public SpinLock {

    HSyncSpinLock( const HSyncSpinLock& );
    HSyncSpinLock& operator=( const HSyncSpinLock& );

  public:
    HSyncSpinLock() {};
};

//===========================================================================//
// class TSyncSpinLock - Serialize a block, syncing at bottom.

// A spinlock that forces a global sync at the tail of the block.
//===========================================================================//

class TSyncSpinLock : public TSync, public SpinLock {

    TSyncSpinLock( const TSyncSpinLock& );
    TSyncSpinLock& operator=( const TSyncSpinLock& );

  public:
    TSyncSpinLock() {};
};

//===========================================================================//
// class HTSyncSpinLock - Serialize a block, syncing at top and bottom.

// A spinlock that forces a global sync at the head and tail of the block.
//===========================================================================//

class HTSyncSpinLock : public HSync, public TSync, public SpinLock {

    HTSyncSpinLock( const HTSyncSpinLock& );
    HTSyncSpinLock& operator=( const HTSyncSpinLock& );

  public:
    HTSyncSpinLock() {};
};

#define SPINLOCK(a) \
{ \
    cout << flush; \
    fflush(stdout); \
    HTSyncSpinLock h; \
    a; \
    cout << flush; \
}

#endif                          // __SpinLock_h__

//---------------------------------------------------------------------------//
//                              end of SpinLock.h
//---------------------------------------------------------------------------//
