//----------------------------------*-C++-*----------------------------------//
// SpinLock.cc
// Geoffrey Furnish
// Fri Dec 16 13:29:02 1994
//---------------------------------------------------------------------------//
// @> A spin lock class.  Serializes execution of a blcok.
//
// $Id: SpinLock.cc,v 1.3 1995/02/01 20:48:21 furnish Exp $
//
// $Log: SpinLock.cc,v $
// Revision 1.3  1995/02/01  20:48:21  furnish
// Convert from NX to generic C4 messaging calls.
//
// Revision 1.2  1995/01/18  16:28:02  furnish
// Generalizations to support C4 objects on both NX and uniprocessor
// configurations.  MPI support yet to be added.
//
// Revision 1.1  1995/01/17  19:16:03  furnish
// Various types of spin locks.  Currently only work with NX.
//
//---------------------------------------------------------------------------//

#include "c4/SpinLock.h"

//---------------------------------------------------------------------------//
// Constructor.  Waits for the preceeding processor to finish before
// continuing. 
//---------------------------------------------------------------------------//

SpinLock::SpinLock()
{
    if (node)
	C4_Recv( &trash, 0, node-1, SL_Next, 0 );
}

//---------------------------------------------------------------------------//
// Here we notify the next processor in the chain that he can proceed to
// execute the block, and we go ahead about our business.
//---------------------------------------------------------------------------//

SpinLock::~SpinLock()
{
    if (node < lastnode)
	C4_Send( &trash, 0, node+1, SL_Next, 0 );
}

//---------------------------------------------------------------------------//
//                              end of SpinLock.cc
//---------------------------------------------------------------------------//

