//----------------------------------*-C++-*----------------------------------//
// DynArraySwap.cc
// Geoffrey Furnish
// Wed Jan 25 16:10:52 1995
//---------------------------------------------------------------------------//
// @> Transport DS++ DynArray<T>'s between nodes.
//
// $Id: DynArraySwap.cc,v 1.2 1995/02/10 19:16:35 furnish Exp $
//
// $Log: DynArraySwap.cc,v $
// Revision 1.2  1995/02/10  19:16:35  furnish
// Due to what appears to be a compiler bug resulting in bogus code
// generation, a regression in usage semantics has been forced.  Should
// look into this some more one of these days.
//
// Revision 1.1  1995/01/27  19:28:51  furnish
// New class for point to point transmission of DS++ DynArray's.
//
//---------------------------------------------------------------------------//

#include "c4/DynArraySwap.h"

#include "Assert.h"

#include "c4/global.h"

//---------------------------------------------------------------------------//
// Constructor.  We take a single DynArray<T> as the argument, and "bind"
// ourselves to it.
//---------------------------------------------------------------------------//

template<class T>
DynArraySwap<T>::DynArraySwap( DynArray<T>& _sda )
    : sda(_sda)
{
//     cout << C4_node() << " DynArraySwap, da is:\n";
//     cout << da << endl << flush;
}

//---------------------------------------------------------------------------//
// Identify this class with a unique number so that messages don't colide.
// This needs to be made automatic and robust.
//---------------------------------------------------------------------------//

template<class T>
int DynArraySwap<T>::id() const
{
    return 92845;
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
int DynArraySwap<T>::extents() const
{
    return 2;
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
int DynArraySwap<T>::bytes( int i ) const
{
    Assert( i >= 0 && i < 2 );

    switch(i) {
    case 0:
	return sizeof(DynArray<T>);

    case 1:
 	return sizeof(T) * (sda.high() - sda.low() + 1);
    }
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
void *DynArraySwap<T>::extent( int i )
{
    Assert( i >= 0 && i < 2 );

    if (i == 0)
	return (void *) &sda;

    if (i == 1)
	return (void *) &sda[sda.low()];
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.  Here we reconstruct the object on the
// target node, based on the bytstream obtained from the object on the
// originating node.
//---------------------------------------------------------------------------//

#include "c4/global.h"

template<class T>
void DynArraySwap<T>::reconstruct()
{
// These opertions are probably more than a little dangerous.  We'll see how
// it goes.  We might have to back off to friendship with member data access.
// The problem is that the data in data_buffer(0) is not /really/ a
// DynArray<T>.  However, since DynArray<T> is not polymorphic, there is no
// vtable, so this /should/ work.  However, it is recognizably dangerous, and
// may require recoding.  We'll just see.

    T defval = ((DynArray<T> *) data_buffer(0)) -> Get_defval();
    int base = ((DynArray<T> *) data_buffer(0)) -> Get_base();
    int sz   = ((DynArray<T> *) data_buffer(0)) -> Get_size();
    float gf = ((DynArray<T> *) data_buffer(0)) -> Get_growthfactor();
    int low  = ((DynArray<T> *) data_buffer(0)) -> low();
    int high = ((DynArray<T> *) data_buffer(0)) -> high();

    DynArray<T> tmp( sz, base, defval, gf );

    for( int i=0; i < high-low+1; i++ )
    //	tmp[base+i] = ((T *) data_buffer(1)) [i];
	tmp[low+i] = ((T *) data_buffer(1)) [i];

    tmp.low(low);
    tmp.high(high);

//     cout << C4_node() << " DynArraySwap<T>::reconstruct, the recv'd array is:\n" 
// 	 << flush;
//     cout << tmp << endl << flush;

    rda = tmp;

//     cout << C4_node() << " the assigned array is:\n" << flush;
//     cout << rda << endl << flush;
}

//---------------------------------------------------------------------------//
//                              end of DynArraySwap.cc
//---------------------------------------------------------------------------//
