//----------------------------------*-C++-*----------------------------------//
// DeepObj.h
// Geoffrey Furnish
// Wed Jan 18 10:48:06 1995
//---------------------------------------------------------------------------//
// @> An abstract class for representing deep, copyable objects.
//
// $Id: DeepObj.h,v 1.2 1995/05/03 20:22:08 furnish Exp $
//
// $Log: DeepObj.h,v $
// Revision 1.2  1995/05/03  20:22:08  furnish
// Typo.
//
// Revision 1.1  1995/01/25  18:47:09  furnish
// A facility for replicating objects (copying from one node to another).
// This employs a basic transport class DeepBSwap which is like BSwap,
// except it works for deep data.  An abstract class DeepObj is provided,
// and DeepBSwap is implemented in terms of these.  Users should derive
// from DeepObj and implement it's missing methods.
//
//---------------------------------------------------------------------------//

#ifndef __DeepObj_h__
#define __DeepObj_h__

#include "Array.h"
#include "DynTable.h"

//===========================================================================//
// class DeepObj - Abstract base class for representing deep objects

// This class provides an abstraction of the concept of a deep object,
// enabling C4 to work with deep data without knowing the precise details.
// The user inherits from DeepObj, supplies the missing methods, and then C4
// can determine whatever it needs to know about the data in order to
// replicate it on another node.
//
// Typically the user will not want to derive his core object facility from
// the C4 DeepObj class, since for many important cases, polymorphism is not
// useful and may even hurt performance.  A useful technique then, is to
// derive from this a class which "wraps" some core object from the client
// code set.  When the wrapper is constructed, it can be bound to a particular
// user object.  Note that the implementation of the abstract methods in this
// class may depend on the details of the object wrapped.  In this way, even
// objects such as Lists or other loosely coupled collection classes may be
// made swappable.
//===========================================================================//

class DeepObj {

  protected:
    int nextents;
    Array<int> ei;

    DynTable<char> extent_data;

  public:
    virtual ~DeepObj() {}

// These are used to querry an existing object.

    virtual int id() const =0;
    virtual int extents() const =0;
    virtual int bytes( int i ) const =0;
    virtual void *extent( int i ) =0;

// These are used to reconstruct an object on a different node.

    virtual void register_extent_info( Array<int>& _ei );
    virtual void *data_buffer( int i );
    virtual void reconstruct() =0;
};

#endif                          // __DeepObj_h__

//---------------------------------------------------------------------------//
//                              end of DeepObj.h
//---------------------------------------------------------------------------//
