//----------------------------------*-C++-*----------------------------------//
// DeepBSwap.h
// Geoffrey Furnish
// Wed Jan 18 10:39:28 1995
//---------------------------------------------------------------------------//
// @> Deep data copying class.
//
// $Id: DeepBSwap.h,v 1.1 1995/01/25 18:47:07 furnish Exp $
//
// $Log: DeepBSwap.h,v $
// Revision 1.1  1995/01/25  18:47:07  furnish
// A facility for replicating objects (copying from one node to another).
// This employs a basic transport class DeepBSwap which is like BSwap,
// except it works for deep data.  An abstract class DeepObj is provided,
// and DeepBSwap is implemented in terms of these.  Users should derive
// from DeepObj and implement it's missing methods.
//
//---------------------------------------------------------------------------//

#ifndef __DeepBSwap_h__
#define __DeepBSwap_h__

#include "c4/config.h"
#include "c4/DeepObj.h"
#include "c4/NodeInfo.h"

//===========================================================================//
// class DeepBSwap - Like BSwap, but for deep data

// Perform a data buffer transfer, but works with "Deep" data.  This is done
// by working through the abstraction of a deep data object.
//
// Note:  Initially this is coded to just send one message for each "extent"
// of the deep object.  However, a buffering approach which copied the data
// into a single block, and unpacked it at the receiver end, might be better
// for some applications.  Depends on how big the data items are going to be.
// Probably this should be turned into a template class taking a "transfer
// policy" implementation class as the template argument.
//===========================================================================//

class DeepBSwap : public NodeInfo {

    DeepBSwap( const DeepBSwap& );
    DeepBSwap& operator=( const DeepBSwap& );

    int other_node;

    enum { xmit = 35798 };

  public:
    DeepBSwap( int _other_node, int sync =0 );
    ~DeepBSwap();

    void send( DeepObj& d );
    void recv( DeepObj& d );
};

#endif                          // __DeepBSwap_h__

//---------------------------------------------------------------------------//
//                              end of DeepBSwap.h
//---------------------------------------------------------------------------//
