//----------------------------------*-C++-*----------------------------------//
// C4_Req.cc
// Geoffrey Furnish
// Wed Feb  1 12:58:33 1995
//---------------------------------------------------------------------------//
// @> A class for managing non blocking message requests.
//
// $Id: C4_Req.cc,v 1.3 1995/02/17 22:38:54 furnish Exp $
//
// $Log: C4_Req.cc,v $
// Revision 1.3  1995/02/17  22:38:54  furnish
// Correction to assignment operator.  This patch is extremely important!
//
// Revision 1.2  1995/02/06  19:34:11  furnish
// Quick hack to handle problem with initialization of C4_Req's.  This
// really needs to be attacked with a better design, but this will get us
// going for the short term.
//
// Revision 1.1  1995/02/01  20:46:46  furnish
// A new class for managing non blocking message requests.  Provides
// auto-waiting and reference counting for your programming pleasure.
//
//---------------------------------------------------------------------------//

#include <iostream.h>

#include "c4/C4_Req.h"

//---------------------------------------------------------------------------//
// Constructor.  Register a new non blocking message request.
//---------------------------------------------------------------------------//

C4_Req::C4_Req()
    : assigned(0)
{
    p = new C4_ReqRefRep;
}

//---------------------------------------------------------------------------//
// Copy constructor.  Attach to an existing message request.
//---------------------------------------------------------------------------//

C4_Req::C4_Req( const C4_Req& req )
{
    assigned = req.assigned;

    p = req.p;
    p->n++;

    PGN( mid = req.mid );
    MPI( r = req.r );
}

//---------------------------------------------------------------------------//
// Destructor.  If we've been left holding the bag, make sure the message has
// completed.  This should plug a wide class of potential programming errors.
//---------------------------------------------------------------------------//

C4_Req::~C4_Req()
{
    p->n--;
    if (!p->n) {
	delete p;
	wait();
    }
}

//---------------------------------------------------------------------------//
// Assignment.  Detach from our prior message request, waiting on it if
// necessary.  Then attach to the new one.
//---------------------------------------------------------------------------//

C4_Req& C4_Req::operator=( const C4_Req& req )
{
    p->n--;
    if (!p->n) {
	delete p;
	wait();
    }

    assigned = req.assigned;

    p = req.p;
    p->n++;

    PGN( mid = req.mid );
    MPI( r = req.r );

    return *this;
}

//---------------------------------------------------------------------------//
// Wait for an asynchronous message to complete.
//---------------------------------------------------------------------------//

void C4_Req::wait()
{
    if (assigned) {
	PGN( msgwait( mid ) );
	MPI( MPI_Wait( &r, &s ) );
    }
    clear();
}

//---------------------------------------------------------------------------//
//                              end of C4_Req.cc
//---------------------------------------------------------------------------//
