//----------------------------------*-C++-*----------------------------------//
// global.cc
// Geoffrey Furnish
// Tue Dec 20 1994
//---------------------------------------------------------------------------//
// @> Improves on the NX API for global operations.
//
// $Id: global.cc,v 1.10 1995/02/07 20:41:16 mjl Exp $
//
// $Log: global.cc,v $
// Revision 1.10  1995/02/07  20:41:16  mjl
// Architecture-dependent parts offloaded to the new files global_mpi.cc,
// global_nx.cc, and global_scalar.cc.  New functions added to handle global
// min/max, and global sum functions added for MPI.
//
// Revision 1.8  1995/02/01  20:47:50  furnish
// New C4 abstractions for blocking and non blocking messaging.
//
// Revision 1.7  1995/01/27  22:17:06  furnish
// Typo correction.
//
// Revision 1.6  1995/01/27  21:02:35  furnish
// Convert global reduction functions to have C4_ prefix.
//
// Revision 1.5  1995/01/23  22:43:56  mjl
// Some cleaning up and elimination of warnings.
//
// Revision 1.4  1995/01/23  19:57:48  furnish
// Various minor improvements.
//
// Revision 1.3  1995/01/18  20:24:27  furnish
// Added some global functions to provide staus info, implemented some
// MPI functionality, etc.
//
// Revision 1.2  1995/01/18  16:28:04  furnish
// Generalizations to support C4 objects on both NX and uniprocessor
// configurations.  MPI support yet to be added.
//
// Revision 1.1  1995/01/17  19:20:05  furnish
// NX global API improvements.  Needs to be generalized for C4.
//
//---------------------------------------------------------------------------//

#include "c4/global.h"

#ifdef __PARAGON__
#include "c4/global_nx.cc"
#endif
#ifdef __MPI__
#include "c4/global_mpi.cc"
#endif
#ifdef __C4_SCALAR__
#include "c4/global_scalar.cc"
#endif

//---------------------------------------------------------------------------//
//                              end of global.cc
//---------------------------------------------------------------------------//
