//----------------------------------*-C++-*----------------------------------//
// DynArraySwap.h
// Geoffrey Furnish
// Wed Jan 25 16:10:51 1995
//---------------------------------------------------------------------------//
// @> Transport DS++ DynArray<T>'s between nodes.
//
// $Id: DynArraySwap.h,v 1.2 1995/02/10 19:16:36 furnish Exp $
//
// $Log: DynArraySwap.h,v $
// Revision 1.2  1995/02/10  19:16:36  furnish
// Due to what appears to be a compiler bug resulting in bogus code
// generation, a regression in usage semantics has been forced.  Should
// look into this some more one of these days.
//
// Revision 1.1  1995/01/27  19:28:52  furnish
// New class for point to point transmission of DS++ DynArray's.
//
//---------------------------------------------------------------------------//

#ifndef __DynArraySwap_h__
#define __DynArraySwap_h__

#include "DynArray.h"

#include "c4/DeepObj.h"

//===========================================================================//
// class DynArraySwap<T> - Transport DS++ DynArray<T> between nodes

// This class implements the C4 DeepObj abstraction for the particular case of
// the DS++ DynArray<T> class.  Essentially this class is used to "wrap" an
// DynArray<T> instance for transport.
//===========================================================================//

template<class T>
class DynArraySwap : public DeepObj {

    DynArray<T>& sda;
    DynArray<T> rda;

  public:
    DynArraySwap( DynArray<T>& _sda );

    DynArray<T> val() const { return rda; }

// Basic info about the contained DynArray<T>.

    virtual int id() const;
    virtual int extents() const;
    virtual int bytes( int i ) const;
    virtual void *extent( int i );

    virtual void reconstruct();
};

#endif                          // __DynArraySwap_h__

//---------------------------------------------------------------------------//
//                              end of DynArraySwap.h
//---------------------------------------------------------------------------//
