//----------------------------------*-C++-*----------------------------------//
// DeepObj.cc
// Geoffrey Furnish
// Wed Jan 18 10:48:07 1995
//---------------------------------------------------------------------------//
// @> An abstract class for representing deep, copyable objects.
//
// $Id: DeepObj.cc,v 1.1 1995/01/25 18:47:08 furnish Exp $
//
// $Log: DeepObj.cc,v $
// Revision 1.1  1995/01/25  18:47:08  furnish
// A facility for replicating objects (copying from one node to another).
// This employs a basic transport class DeepBSwap which is like BSwap,
// except it works for deep data.  An abstract class DeepObj is provided,
// and DeepBSwap is implemented in terms of these.  Users should derive
// from DeepObj and implement it's missing methods.
//
//---------------------------------------------------------------------------//

#include "c4/DeepObj.h"

//---------------------------------------------------------------------------//
// This method is called to inform us of how much data is required to
// reconstruct the object after transmission.  We save this info, and prepare
// room for receiving the byte stream.
//---------------------------------------------------------------------------//

void DeepObj::register_extent_info( Array<int>& _ei )
{
    ei = _ei;
    int nextents = ei.size();

// Now go and expand the data buffer space to be big enough to hold the
// incoming byte stream.

    for( int i=0; i < nextents; i++ ) {
	extent_data(i,0) = ' ';
	extent_data(i,ei[i]-1) = ' ';
    }
}

//---------------------------------------------------------------------------//
// Return a pointer to a buffer big enough to hold the requested extent.  Up
// to the client to make sure he doesn't write more data than what he told us
// before was coming (when he called register_extent_info()).
//---------------------------------------------------------------------------//

void *DeepObj::data_buffer( int i )
{
    return (void *) &extent_data(i,0);
}

//---------------------------------------------------------------------------//
//                              end of DeepObj.cc
//---------------------------------------------------------------------------//
