//----------------------------------*-C++-*----------------------------------//
// DeepBSwap.cc
// Geoffrey Furnish
// Wed Jan 18 10:39:28 1995
//---------------------------------------------------------------------------//
// @> Deep data copying class.
//
// $Id: DeepBSwap.cc,v 1.3 1995/02/10 19:16:34 furnish Exp $
//
// $Log: DeepBSwap.cc,v $
// Revision 1.3  1995/02/10  19:16:34  furnish
// Due to what appears to be a compiler bug resulting in bogus code
// generation, a regression in usage semantics has been forced.  Should
// look into this some more one of these days.
//
// Revision 1.2  1995/01/27  19:28:07  furnish
// Remove debugging output messages.
//
// Revision 1.1  1995/01/25  18:47:06  furnish
// A facility for replicating objects (copying from one node to another).
// This employs a basic transport class DeepBSwap which is like BSwap,
// except it works for deep data.  An abstract class DeepObj is provided,
// and DeepBSwap is implemented in terms of these.  Users should derive
// from DeepObj and implement it's missing methods.
//
//---------------------------------------------------------------------------//

#include "Assert.h"

#include "c4/DeepBSwap.h"
#include "c4/global.h"

//---------------------------------------------------------------------------//
// Constructor.  Setup and sync if requested.
//---------------------------------------------------------------------------//

DeepBSwap::DeepBSwap( int _other_node, int sync /*=0*/ )
     : other_node(_other_node)
{
    if (sync)
	throw( "Unimplemented." );
}

//---------------------------------------------------------------------------//
// Tear down any internal machinery.
//---------------------------------------------------------------------------//

DeepBSwap::~DeepBSwap()
{
}

//---------------------------------------------------------------------------//
// Send a buffer of "deep" data.
//---------------------------------------------------------------------------//

void DeepBSwap::send( DeepObj& d )
{
    int m1[2];
    m1[0] = d.id();
    m1[1] = d.extents();

// Send our object id and the number of extents.

    C4_Send( m1, 2 * sizeof(int), other_node, xmit+0, group );

    Array<int> m2( d.extents() );

    for( int i=0; i < d.extents(); i++ )
	m2[i] = d.bytes(i);

// Send the length of the extents.

    C4_Send( &m2[0], d.extents() * sizeof(int), other_node, xmit+1, group );

// Send the extents.

    for( i=0; i < d.extents(); i++ )
	C4_Send( d.extent(i), d.bytes(i), other_node, xmit+2+i, group);
}

//---------------------------------------------------------------------------//
// Receive a "deep" buffer.
//---------------------------------------------------------------------------//

void DeepBSwap::recv( DeepObj& d )
{
    int m1[2];
    int& extents = m1[1];

// Obtain and verify the object id and number of extents.

    C4_Recv( m1, 2 * sizeof(int), other_node, xmit+0, group);

    Assert( m1[0] == d.id() );

    Array<int> m2( extents );

// Obtain the extent length info, and inform the object.

    C4_Recv( &m2[0], extents * sizeof(int), other_node, xmit+1, group );

    d.register_extent_info( m2 );

// Acquire the data, storing in the space allocated by the object.

    for( int i=0; i < extents; i++ ) {
	int n;
	n = C4_Recv( d.data_buffer(i), m2[i], other_node, xmit+2+i, group );
	if ( n != m2[i] )
	    cout << node << " DeepBSwap::recv, not enough bytes recvd.\n"
		 << flush;
    }

    d.reconstruct();
}

//---------------------------------------------------------------------------//
//                              end of DeepBSwap.cc
//---------------------------------------------------------------------------//
