//----------------------------------*-C++-*----------------------------------//
// C4_Req.h
// Geoffrey Furnish
// Wed Feb  1 12:58:32 1995
//---------------------------------------------------------------------------//
// @> A class for managing non blocking message requests.
//
// $Id: C4_Req.h,v 1.3 1995/05/01 17:07:40 furnish Exp $
//
// $Log: C4_Req.h,v $
// Revision 1.3  1995/05/01  17:07:40  furnish
// Documentation cleanup, preparing for release.
//
// Revision 1.2  1995/02/06  19:34:12  furnish
// Quick hack to handle problem with initialization of C4_Req's.  This
// really needs to be attacked with a better design, but this will get us
// going for the short term.
//
// Revision 1.1  1995/02/01  20:46:47  furnish
// A new class for managing non blocking message requests.  Provides
// auto-waiting and reference counting for your programming pleasure.
//
//---------------------------------------------------------------------------//

#ifndef __C4_Req_h__
#define __C4_Req_h__

#include "c4/config.h"

// autodoc: noprint C4_ReqRefRep

struct C4_ReqRefRep {
    int n;

    C4_ReqRefRep() { n = 1; }
};

//===========================================================================//
// class C4_Req - Handle for non blocking message requests

// This class provides an encapsulator for the message id's (NX) or requests
// (MPI) which are produced by non blocking calls.  This class automatically
// waits for the message to complete when the containing object goes out of
// scope, thus plugging one of the easiest types of programming errors with
// non blocking messaging.  Reference counting is used so that these may be
// passed by value without accidentally triggering a program stall.
//===========================================================================//

class C4_Req {

    C4_ReqRefRep *p;

    int assigned;

  public:			// So C4 api functions can see them, but
				// don't anybody else touch them!
#ifdef __PARAGON__
    long mid;
#endif
#ifdef __MPI__
    MPI_Status  s;
    MPI_Request r;
#endif

  public:
    C4_Req();
    C4_Req( const C4_Req& req );
    ~C4_Req();
    C4_Req& operator=( const C4_Req& req );

    void set()      { assigned = 1; }
    void clear()    { assigned = 0; }

    void wait();
};

#endif                          // __C4_Req_h__

//---------------------------------------------------------------------------//
//                              end of C4_Req.h
//---------------------------------------------------------------------------//
