//----------------------------------*-C++-*----------------------------------//
// Baton.h
// Geoffrey Furnish
// Thu Apr 13 15:54:13 1995
//---------------------------------------------------------------------------//
// @> A spinlock which transmitts a value between nodes.
//
// $Id: Baton.h,v 1.1 1995/04/14 21:06:51 furnish Exp $
//
// $Log: Baton.h,v $
// Revision 1.1  1995/04/14  21:06:51  furnish
// A new class for handling cases where each node needs a result from the
// prior node in order to procede.
//
//---------------------------------------------------------------------------//

#ifndef __Baton_h__
#define __Baton_h__

#include "c4/NodeInfo.h"

//===========================================================================//
// class Baton<T> - Spinlock which passes a value between nodes.

// The Baton<T> class is used to handle a case where a node needs to do work
// which depends on an answer from the preceeding node.  <More blurb...>
//===========================================================================//

template<class T>
class Baton : public NodeInfo {

    T& v;

    Baton( const Baton& );
    Baton& operator=( const Baton& );

  public:
    Baton( T& _v );
    ~Baton();
};

#endif                          // __Baton_h__

//---------------------------------------------------------------------------//
//                              end of Baton.h
//---------------------------------------------------------------------------//
