//----------------------------------*-C++-*----------------------------------//
// Baton.cc
// Geoffrey Furnish
// Thu Apr 13 15:54:14 1995
//---------------------------------------------------------------------------//
// @> A spinlock which transmitts a value between nodes.
//
// $Id: Baton.cc,v 1.1 1995/04/14 21:06:51 furnish Exp $
//
// $Log: Baton.cc,v $
// Revision 1.1  1995/04/14  21:06:51  furnish
// A new class for handling cases where each node needs a result from the
// prior node in order to procede.
//
//---------------------------------------------------------------------------//

#include "c4/Baton.h"
#include "c4/BSwap.h"

//---------------------------------------------------------------------------//
// Constructor.  If not node zero, wait for the previous node to tell us his
// result. 
//---------------------------------------------------------------------------//

template<class T>
Baton<T>::Baton( T& _v )
    : v(_v)
{
    if (node > 0) {
	BSwap<T> bs(node-1);

	bs.recv(v);
    }
}

//---------------------------------------------------------------------------//
// Destructor.  If not lastnode, send our result to the next node, enabling
// him to procede.
//---------------------------------------------------------------------------//

template<class T>
Baton<T>::~Baton()
{
    if (node < lastnode) {
	BSwap<T> bs(node+1);

	bs.send(v);
    }
}

//---------------------------------------------------------------------------//
//                              end of Baton.cc
//---------------------------------------------------------------------------//
