//----------------------------------*-C++-*----------------------------------//
// BSwap.h
// Geoffrey Furnish
// Tue Jan 17 13:49:50 1995
//---------------------------------------------------------------------------//
// @> A buffer swapper class.
//
// $Id: BSwap.h,v 1.2 1995/02/01 21:59:16 furnish Exp $
//
// $Log: BSwap.h,v $
// Revision 1.2  1995/02/01  21:59:16  furnish
// Converted away from explicit calls to NX or MPI, and switched to calls
// to the C4 abstraction layer.  Now shorter and clearer.
//
// Revision 1.1  1995/01/18  16:25:52  furnish
// A class for performing point to point typesafe transfers of data
// buffers (i.e., "flat objects").  Currently uses synchronous semantics.
//
//---------------------------------------------------------------------------//

#ifndef __BSwap_h__
#define __BSwap_h__

#include "c4/NodeInfo.h"

//===========================================================================//
// class BSwap - Exchange data buffer between two nodes

// This class provides a typesafe interface to the traditional send and
// receive functions found in message passing libraries.
//
// Note:  This class currently uses synchronous communication primitives.  It
// is not yet decided how we will handle typesafe asynchronous communication.
// We could either make a new class BSwapAsync, or we could add a constructor
// argument, or we could add an argument to the transaction methods, with
// suitable defaults.  Have to think about this issue some more.
//===========================================================================//

template<class T>
class BSwap : public NodeInfo {

    BSwap( const BSwap& );
    BSwap& operator=( const BSwap& );

    int other_node;

    enum { BS_Hello = 35465,
	   BS_xmit };

  public:
    BSwap( int _other_node, int sync =0 );
    ~BSwap();

    void send( const T& d );
    void recv( T& d );

    void swap( T& d );
    void swap( const T& sd, T& rd );
};

#endif                          // __BSwap_h__

//---------------------------------------------------------------------------//
//                              end of BSwap.h
//---------------------------------------------------------------------------//
