//----------------------------------*-C++-*----------------------------------//
// BSwap.cc
// Geoffrey Furnish
// Tue Jan 17 13:49:51 1995
//---------------------------------------------------------------------------//
// @> A buffer swapper class.
//
// $Id: BSwap.cc,v 1.3 1995/02/01 21:59:15 furnish Exp $
//
// $Log: BSwap.cc,v $
// Revision 1.3  1995/02/01  21:59:15  furnish
// Converted away from explicit calls to NX or MPI, and switched to calls
// to the C4 abstraction layer.  Now shorter and clearer.
//
// Revision 1.2  1995/01/18  21:02:55  furnish
// Test program for BSwap, and implementation on MPI.
//
// Revision 1.1  1995/01/18  16:25:52  furnish
// A class for performing point to point typesafe transfers of data
// buffers (i.e., "flat objects").  Currently uses synchronous semantics.
//
//---------------------------------------------------------------------------//

#include "c4/BSwap.h"
#include "c4/global.h"

#include "Assert.h"

//---------------------------------------------------------------------------//
// Constructor.  Set up internal state and prepare for communiction.  Sync
// with partner if requested.
//---------------------------------------------------------------------------//

template<class T>
BSwap<T>::BSwap( int _other_node, int sync /*=0*/ )
    : other_node(_other_node)
{
    if (sync) {
    // It's probably not a good idea to use this in the general case, since I
    // suppose deadlocks are probably pretty easy to trigger.  But if the
    // pattern of hookups is well understood, it may be possible to use this
    // to effect.

	int trash;

	if (node < other_node) {

	// Send salutation.
	    C4_Send( &trash, 0, other_node, BS_Hello, group );

	// Wait for acknoledgement.
	    C4_Recv( &trash, 0, other_node, BS_Hello, group );

	} else if ( node > other_node ) {

	// Wait for salutation.
	    C4_Recv( &trash, 0, other_node, BS_Hello, group );

	// Send acknoledgement.
	    C4_Send( &trash, 0, other_node, BS_Hello, group );

	} else {

	// Swap with self?  Does this guy know what he's doing?
	    throw( "Excuuuuuse me?" );
	}
    }
}

//---------------------------------------------------------------------------//
// Tear down any internal machinery.
//---------------------------------------------------------------------------//

template<class T>
BSwap<T>::~BSwap()
{
}

//---------------------------------------------------------------------------//
// Send a data buffer to the other node.
//---------------------------------------------------------------------------//

template<class T>
void BSwap<T>::send( const T& d )
{
    C4_Send( (void *) &d, sizeof(d), other_node, BS_xmit, group );
}

//---------------------------------------------------------------------------//
// Receive a data buffer from the other node.
//---------------------------------------------------------------------------//

template<class T>
void BSwap<T>::recv( T& d )
{
    int len = C4_Recv( &d, sizeof(d), other_node, BS_xmit, group );

    Assert( len == sizeof(d) );
}

//---------------------------------------------------------------------------//
// Perform "in-place" exchange of data buffer with other node.
//---------------------------------------------------------------------------//

template<class T>
void BSwap<T>::swap( T& d )
{
    send( d );
    recv( d );
}

//---------------------------------------------------------------------------//
// Swap data with the other node, but don't overwrite the send buffer with the
// received data.
//---------------------------------------------------------------------------//

template<class T>
void BSwap<T>::swap( const T& sd, T& rd )
{
    send( sd );
    recv( rd );
}

//---------------------------------------------------------------------------//
//                              end of BSwap.cc
//---------------------------------------------------------------------------//
