//----------------------------------*-C++-*----------------------------------//
// ArraySwap.h
// Geoffrey Furnish
// Mon Jan 23 15:24:51 1995
//---------------------------------------------------------------------------//
// @> Transport DS++ Array<T>'s between nodes.
//
// $Id: ArraySwap.h,v 1.1 1995/01/25 18:50:56 furnish Exp $
//
// $Log: ArraySwap.h,v $
// Revision 1.1  1995/01/25  18:50:56  furnish
// Specialization of DeepObj for DS++ Array<T>.  With test case and
// template instantiation support.
//
//---------------------------------------------------------------------------//

#ifndef __ArraySwap_h__
#define __ArraySwap_h__

#include "Array.h"

#include "c4/DeepObj.h"

//===========================================================================//
// class ArraySwap<T> - Transport DS++ Array<T> between nodes

// This class implements the C4 DeepObj abstraction for the particular case of
// the DS++ Array<T> class.  Essentially this class is used to "wrap" an
// Array<T> instance for transport.
//===========================================================================//

template<class T>
class ArraySwap : public DeepObj {

    Array<T>& a;

  public:
    ArraySwap( Array<T>& _a );

// Basic info about the contained Array<T>.

    virtual int id() const;
    virtual int extents() const;
    virtual int bytes( int i ) const;
    virtual void *extent( int i );

    virtual void reconstruct();
};

#endif                          // __ArraySwap_h__

//---------------------------------------------------------------------------//
//                              end of ArraySwap.h
//---------------------------------------------------------------------------//
