//----------------------------------*-C++-*----------------------------------//
// ArraySwap.cc
// Geoffrey Furnish
// Mon Jan 23 15:24:51 1995
//---------------------------------------------------------------------------//
// @> Transport DS++ Array<T>'s between nodes.
//
// $Id: ArraySwap.cc,v 1.2 1995/01/27 19:27:53 furnish Exp $
//
// $Log: ArraySwap.cc,v $
// Revision 1.2  1995/01/27  19:27:53  furnish
// Correction to work with Array's with non-zero base.
//
// Revision 1.1  1995/01/25  18:50:55  furnish
// Specialization of DeepObj for DS++ Array<T>.  With test case and
// template instantiation support.
//
//---------------------------------------------------------------------------//

#include "c4/ArraySwap.h"

#include "Assert.h"

//---------------------------------------------------------------------------//
// Constructor.  We take a single Array<T> as the argument, and "bind"
// ourselves to it.
//---------------------------------------------------------------------------//

template<class T>
ArraySwap<T>::ArraySwap( Array<T>& _a )
    : a(_a)
{
}

//---------------------------------------------------------------------------//
// Identify this class with a unique number so that messages don't colide.
// This needs to be made automatic and robust.
//---------------------------------------------------------------------------//

template<class T>
int ArraySwap<T>::id() const
{
    return 92834;
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
int ArraySwap<T>::extents() const
{
    return 2;
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
int ArraySwap<T>::bytes( int i ) const
{
    Assert( i >= 0 && i < 2 );

    switch(i) {
    case 0:
	return sizeof(Array<T>);

    case 1:
 	return sizeof(T) * a.size();
    }
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.
//---------------------------------------------------------------------------//

template<class T>
void *ArraySwap<T>::extent( int i )
{
    Assert( i >= 0 && i < 2 );

    if (i == 0)
	return (void *) &a;

    if (i == 1)
	return (void *) &a[a.base()];
}

//---------------------------------------------------------------------------//
// Implement DeepObj abstraction.  Here we reconstruct the object on the
// target node, based on the bytstream obtained from the object on the
// originating node.
//---------------------------------------------------------------------------//

template<class T>
void ArraySwap<T>::reconstruct()
{
// These opertions are probably more than a little dangerous.  We'll see how
// it goes.  We might have to back off to friendship with member data access.
// The problem is that the data in data_buffer(0) is not /really/ an Array<T>.
// However, since Array<T> is not polymorphic, there is no vtable, so this
// /should/ work.  However, it is recognizably dangerous, and may require
// recoding.  We'll just see.

    int base = ((Array<T> *) data_buffer(0)) -> base();
    int sz   = ((Array<T> *) data_buffer(0)) -> size();

    Array<T> b( sz, base );

    for( int i=0; i < sz; i++ )
	b[base+i] = ((T *) data_buffer(1)) [i];

    a = b;
}

//---------------------------------------------------------------------------//
//                              end of ArraySwap.cc
//---------------------------------------------------------------------------//
