
FOREIGN MODULE msXCW;

(*
 *  Simple Chess Window Library for Modula-2*
 *
 *  all output goes to the chess window
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation derived from "xics" and "msXDW" by Ernst A. Heinz
 *
 *  Last change: 31.01.1995
 *)

VAR CWBoard : ARRAY[0..7],[0..7] OF CHAR;   (* a1=[0,0] e4=[4,3] h8=[7,7] *)
    CWText  : ARRAY[0..7],[0..79] OF CHAR;

PROCEDURE ClearCWText;
PROCEDURE ClearCWBoard;
PROCEDURE InitCWBoard;

PROCEDURE CloseCW;
PROCEDURE EditPosInCW;
PROCEDURE GetMoveInCW( VAR NextMove: ARRAY OF CHAR );
PROCEDURE GetPromInCW( VAR NewPiece: CHAR );
PROCEDURE OpenCW( wtitle: ARRAY OF CHAR );
PROCEDURE RedrawCW;
PROCEDURE UpdateCW;

PROCEDURE CloseChessWindow;
PROCEDURE EditPositionInChessWindow;
PROCEDURE GetMoveInChessWindow( VAR NextMove: ARRAY OF CHAR );
PROCEDURE GetPromotionInChessWindow( VAR NewPiece: CHAR );
PROCEDURE OpenChessWindow( wtitle: ARRAY OF CHAR );
PROCEDURE RedrawChessWindow;
PROCEDURE UpdateChessWindow;

END msXCW.
