
/*
 *  Easy Timer Library for Modula-2*
 *
 *  "TimerElapsed" returns the user time since the last
 *  call to "TimerStart" measured in seconds
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change:  29.03.1994
 */

#include "msTimer.SUN5.h"
#include <sys/time.h>
#include <time.h>


static struct timespec  msTimerStruct;


void TimerStart()
{
  if (clock_gettime(CLOCK_REALTIME, &msTimerStruct) != 0)
    exit(-1);
}


LONGREAL TimerElapsed()
{
    struct timespec	ts;

    if (clock_gettime(CLOCK_REALTIME,&ts) != 0)
      exit(-1);

    return( ((double) 1e9 * (double) (ts.tv_sec  - msTimerStruct.tv_sec) +
	     (double) (ts.tv_nsec - msTimerStruct.tv_nsec))
            / (double) 1e9
	  );
}
