
#include <stdio.h>

#include "SYSTEM.SUN5.h"

/*
 *	Implementation of standard functions
 */

LONGINT ABSLI(x)
register LONGINT x;
{
	return (x < 0 ? -x : x);
}

LONGREAL ABSLR(x)
register LONGREAL x;
{
	return (x < 0 ? -x : x);
}

CHAR CAP(ch)
register CHAR ch;
{
    return (ch >= 'a' && ch <= 'z' ? ch - 'a' + 'A' : ch);
}

/*
 *	Implementation of set operators
 */

unsigned long SET_RANGE1(lo, hi)
register CARDINAL lo, hi;
{
    return (lo <= hi ? ~0L >> lo << lo + SYSTEM_MaxSet - hi >> SYSTEM_MaxSet - hi : 0L);
}

/*
 *	Implementation of compiler functions
 */

void CaseError(file, line)
char file[];
int line;
{
    (void)fprintf (stderr, "\"%s\", line %1d: case expression out of range\n", file, line);
    exit(1);
}

void ReturnError(file, line)
char file[];
int line;
{
    (void)fprintf (stderr, "\"%s\", line %1d: missing return from function\n", file, line);
    exit(1);
}

/*
 *	Main program
 */

extern void BEGIN_MODULE();

int    SYSTEM_argc;
char **SYSTEM_argv;
char **SYSTEM_envp;

main(argc, argv, envp)
int argc;
char *argv[], *envp[];
{
  SYSTEM_argc = argc;
  SYSTEM_argv = argv;
  SYSTEM_envp = envp;

  BEGIN_MODULE();

  exit(0);
}
