/*
 * xmsc.h	common definitions for xmsc.c & fileselect.c
 *
 * Stefan Haenssgen 7-sep-93
 *
 * 07-sep-93	Joined common definitions
 * 09-sep-93	Added paned Widget
 * 23-sep-93	Full "About" string
 * 03-mar-95	User input support, now version 1.1
 *
 */

#ifndef XMSC_H
#define XMSC_H

#include <stdio.h>
#include <signal.h>
#include <termio.h>
#include <ctype.h>
#include <dirent.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextP.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Cardinals.h>

#define Version	    "1.1"
#define WindowTitle "Xmsp - The Modula-2* Environment Panel (1.1)"
#define IconTitle   "Xmsp 1.1"

#define AboutString "\
  \n\
  The Modula-2* Environment for Parallel Programming was  \n\
  developed at the Institute for Program Structures and Data  \n\
  Organization (IPD), Department of Computer Science, University  \n\
  of Karlsruhe, Germany  \n\
  \n\
  Thomas Gauweiler    (makefile generator)  \n\
  Stefan U. Haenssgen (debugger, msXDW, xmsp) \n\
  Ernst A. Heinz      (compiler, demos, make drivers, libraries)  \n\
  Paul Lukowicz       (compiler, demos)  \n\
  Hendrik Mager       (semantic analysis)  \n\
  Michael Philippsen  (benchmarks, compiler, test suite)  \n\
  \n\
  For further information contact the Modula-2* team \n\
  at msc@ira.uka.de  \n\
  \n"

/* Modes for file selector */

#define PROGMODE 1
#define PROJMODE 2
#define ARCHMODE 3

extern void	 File();		/* File selection menu		*/
extern void	 SetUpFileMenu();	/* Create the file menu popup	*/
extern char	 cwd[];			/* Working directory		*/

extern char	 progpath[];		/* Program path			*/
extern char	 progname[];		/* Program name			*/
extern char	 projpath[];		/* Project path			*/
extern char	 archpath[];		/* Architecture path		*/
extern char	 archname[];		/* Architecture name		*/

extern void	 AddLog();
extern Widget	 toplevel, paned;
extern Display	*display;
extern Cursor	 watch;

extern Widget	 EnterProjW, EnterProgW, EnterArchW;

#endif
