/*
 * xmsp		X Interface for Modula-2* development
 *
 * Stefan Haenssgen 26-aug-93
 *
 * 31-aug-93	Added more Resources, start strings also als resources
 *		New buttons for execute, debug and edit (corresponding
 *		 commands as resources)
 * 01-sep-93	Moved Quit button above log window
 *		Renamed "DoIt*|Command*" to "Make*"
 *		New "Make Clean" button
 *		Shorter button texts
 *		ButtonBox for all buttons
 *		New title and icon name
 * 02-sep-93	I/O via pty instead of popen [from calldbx.c]
 *		 (Master & slave ptys, creation, initialization etc)
 *		Edit <-> Debug fields swap
 *		Command line:	1st arg = architecture
 *				2nd	= machine
 *				3rd	= program
 *				4th	= options
 *		Call all command strings with all 4 parameters
 *		Use file menu (adapted from xdbx)
 * 03-sep-93	Use cwd for project directory
 *		New button/entry for directory, corresp. resources
 * 06-sep-93	Use button in some entry label widgets (e.g. for popping
 *		 up the directory selection)
 *		New callback procedures for that purpose
 *		Also log selection of directories
 * 07-sep-93	Common stuff in xmsp.h
 *		New path variables (prog,proj,arch)
 *		Modes for file selector, prog -> select msm/xx.msm
 *		 proj -> select directory, arch -> select from arch directory
 *		Set cancelButton labels accordingly
 *		Update paths & names when file/dir selected
 *		Also update displayed strings
 *		Program path = Project path + "msm/"
 *		Renamed Dir* to Proj*
 * 08-sep-93	Look for architectures in "imp/" (no more ArchDirS)
 *		Filter out ".msm"
 *		Also update ProgS etc when progname/path etc change
 *		Directory change only when in project mode
 *		Better labels for prog/arch mode ("Select a ...")
 * 09-sep-93	Sequence of parameters changed
 *		Better file list spacing
 *		Fileselector placed in middle of paned Widget
 *		Show About-String in log window on startup
 *		About-button with own popupshell etc
 *		Less debug output
 *		Align file selector to left
 * 17-sep-93	Added Clear button (remove program)
 *		Always re-read directory on popup (files could have been
 *		 added/removed)
 * 22-sep-93	Renamed Clear to ProgClean
 * 03-mar-95	Use execvp instead of system call, less zombies, faster start
 *		!!!!! also cuts through spaces in user text ("...") !!!
 *		Added input widget for interaction with programs
 *		 (InptW etc pp, callback sends output to pty)
 *		Clear input line after user pressed return
 *
 */


/*   i/o probleme (rsh, msdb nix?!?)
     size groesser schrift (fuer scrollbar)
 */

#include "xmsp.h"

Widget  toplevel,paned,			/* Base windows			*/
        ButtonBoxW,			/* Box for all buttons:		*/
        AboutW,				/* "About" button		*/
        MakeW,				/* Start make process button	*/
        CleanW,				/* Start make clean button	*/
        ProgCleanW,			/* Start remove program button	*/
        ExecuteW,			/* Execute program button	*/
        EditW,				/* Edit file button		*/
        DebugW,				/* Debug program button		*/
        BoxW,				/* Box containing the dialogs	*/
        ProjW,LabelProjW,EnterProjW,	/* Project directory entry	*/
        ProgW,LabelProgW,EnterProgW,	/* Program name entry		*/
        ArchW,LabelArchW,EnterArchW,	/* Architecture			*/
        MachW,LabelMachW,EnterMachW,	/* Machine			*/
        OptsW,LabelOptsW,EnterOptsW,	/* Make options			*/
        InptW,LabelInptW,EnterInptW,	/* User input for program	*/
        LogW,				/* Log window			*/
        QuitW;				/* Quit button			*/

Widget	AboutPopupShell, AboutPopup;	/* About popup			*/

void	Make(),Clean(),Execute(),	/* Callbacks/Action routines	*/
        ProgClean(), Edit(),Debug(),
        EnterProj(),EnterProg(),EnterArch(),
        EnterMach(),EnterOpts(),
        EnterInpt(),
        Quit();
void	About(),PopdownAbout();

void	AddBox();			/* Create label/entry pair box	*/
void	AddButton();			/* Create button in button box	*/
void	AddLog();			/* Add text to log window	*/
					 
char		 progpath[BUFSIZ];	/* Program path 		*/
char		 progname[BUFSIZ];	/* Program name			*/
char		 projpath[BUFSIZ];	/* Project path			*/
char		 archpath[BUFSIZ];	/* Architecture path		*/
char		 archname[BUFSIZ];	/* Architecture name		*/

char		*start_argv[32];	/* Argv for started program	*/
int		 start_argc = 0;

Display		*display;
XtAppContext	 app_con;
Cursor		 watch;
XtInputId	 input;			/* Input from pty		*/
FILE		*ptyfp=NULL;		/* File pointer for pty		*/
int		 childpid=0;		/* PID of child process		*/
char     	 pty[11] = "/dev/pty??";/* Master side of pseudo-term.	*/
char     	 tty[11] = "/dev/tty??";/* Slave side of pseudo-terminal*/
int           	 master;                /* File descriptor of master pty*/
int           	 slave;                 /*  slave pty			*/
XawTextPosition	 loglen=0;		/* Length of log buffer		*/

int	open_master(),open_slave();	/* PTY initialization		*/
void	create_ptys();

#define checkstring(s,m)						\
 {if ((s==NULL) || (strlen(s)<2))					\
    {fprintf(stderr,"%s: %s undefined!\n",argv[0],m); exit(1);}};
#define AddButton(name,w,call) 						      \
 {w = XtCreateManagedWidget(name, commandWidgetClass, ButtonBoxW, NULL, ZERO);\
  XtAddCallback(w, XtNcallback, call, NULL);};

char	*ProjS,*ProgS,*ArchS,		/* Strings in dialogs		*/
        *MachS,*OptsS,*InptS;
char    *textbuf;			/* Text buffer for Log		*/

static XtActionsRec actions[] = {	/* Our own actions with		*/
    {"EnterProj", EnterProj},		/*  corresponding functions	*/
    {"EnterProg", EnterProg},
    {"EnterArch", EnterArch},
    {"EnterMach", EnterMach},
    {"EnterOpts", EnterOpts},
    {"EnterInpt", EnterInpt},
    NULL
};


typedef struct {			/* Our own resources		*/
    String	makeS;			/* String for starting mm	*/
    String	cleanS;			/* String for cleaning files	*/
    String	progClearS;		/* String for removing progam	*/
    String	executeS;		/* For starting executable	*/
    String	editS;			/* For starting editor		*/
    String	debugS;			/* For starting debugger	*/
} AppResources;
AppResources   app_resources; 
#define Offset(field) (XtOffset(AppResources *, field))
static XtResource resources[] = {
    {"makeS", "MakeS", XtRString, sizeof(char *),
        Offset(makeS), XtRString, (caddr_t)NULL},
    {"cleanS", "CleanS", XtRString, sizeof(char *),
        Offset(cleanS), XtRString, (caddr_t)NULL},
    {"progClearS", "ProgCleanS", XtRString, sizeof(char *),/* Defaults	*/
        Offset(progClearS), XtRString, (caddr_t)NULL},	/*  set in	*/
    {"executeS", "ExecuteS", XtRString, sizeof(char *),	/*  Fallback	*/
        Offset(executeS), XtRString, (caddr_t)NULL},	/*  Resources	*/
    {"editS", "EditS", XtRString, sizeof(char *),	/*  below!	*/
        Offset(editS), XtRString, (caddr_t)NULL},
    {"debugS", "DebugS", XtRString, sizeof(char *),
        Offset(debugS), XtRString, (caddr_t)NULL},
    NULL
};

String fallback_resources[] = {
    /* Start the make process (params: program,architecture,machine,options)*/
    "*MakeS: 			mm %s:%s@%s %s",
    /* Clean object files (dito) */
    "*CleanS: 			mmclean %s:%s@%s %s",
    /* Remove the program (dito) */
    "*ProgCleanS:		msrm %s:%s@%s %s",
    /* Execute the program (dito) */
    "*ExecuteS: 		xterm -e msrun %s:%s@%s %s",
    /* Edit the main program (dito) */
    "*EditS:    		xedit msm/%s.msm",
    /* Debug the program (dito) */
    "*DebugS:   		msdb bin/SUN4/%s.%s",

    "*AboutW*label:		About Xmsp",		/* Button labels    */
    "*MakeW*label:		Make All",
    "*CleanW*label:		Make Clean",
    "*ProgCleanW*label:		Prog Clean",
    "*ExecuteW*label:		Execute",
    "*EditW*label:		Edit",
    "*DebugW*label:		Debug",
    "*QuitW*label:		Quit",

    "*ButtonBoxW*hSpace:	7",			/* Button spacing   */
    "*ButtonBoxW*vSpace:	5",
 
    "*LabelProjW*label:		Project Dir  : ",	/* Data labels	    */
    "*LabelProgW*label:		Program      : ",
    "*LabelArchW*label:		Architecture : ",
    "*LabelMachW*label:		Machine      : ",
    "*LabelOptsW*label:		Options      : ",
    "*LabelInptW*label:		User Input   : ",
    "*EnterProjW*width:		440",			/* Entry fields size*/
    "*EnterProgW*width:		440",
    "*EnterArchW*width:		440",
    "*EnterMachW*width:		440",
    "*EnterOptsW*width:		440",
    "*EnterInptW*width:		440",
    "*EnterProjW*hScrollbar.height: 3",			/* Limit scrollbars */
    "*EnterProgW*hScrollbar.height: 3",
    "*EnterInptW*hScrollbar.height: 3",

    "*fileMenu*columnSpacing:	10",

    "*LogW.width:		510",			/* Size of logdisp. */
    "*LogW.height:		650",
    "*LogW*font:		fixed",
    "*LogW.allowResize:		True",
    
    "*allowShellResize:		True",
    "*showGrip:			False",
    
    "*EnterProjW.translations:       #override \\n\
        <LeaveWindow>  : EnterProj() \\n\
        <Key>Return : end-of-line() EnterProj()",
    "*EnterProgW.translations:       #override \\n\
        <LeaveWindow>  : EnterProg() \\n\
        <Key>Return : end-of-line() EnterProg()",	/* Translations for */
    "*EnterArchW.translations:       #override \\n\
        <LeaveWindow>  : EnterArch() \\n\
        <Key>Return : end-of-line() EnterArch()",	/*  Return key in   */
    "*EnterMachW.translations:       #override \\n\
        <LeaveWindow>  : EnterMach() \\n\
        <Key>Return : end-of-line() EnterMach()",	/*  data entry      */
    "*EnterOptsW.translations:       #override \\n\
        <LeaveWindow>  : EnterOpts() \\n\
        <Key>Return : end-of-line() EnterOpts()",
    "*EnterInptW.translations:       #override \\n\
        <Key>Return : end-of-line() EnterInpt()",	/*  user input 	    */
    
    NULL
};



main(argc, argv)
int argc;
char **argv;
{
    int    n,i;
    Arg    args[10];

    toplevel = XtAppInitialize(&app_con, "Xmsp",
                               NULL,ZERO,
                               &argc, argv, fallback_resources,
                               NULL, ZERO);

    /* Get resources, set action procedures */
       
    XtGetApplicationResources(toplevel, &app_resources, resources,
                              XtNumber(resources), NULL, 0);
    XtAppAddActions(app_con, actions, XtNumber(actions));

    n=0;
    paned= XtCreateManagedWidget("Paned", panedWidgetClass, toplevel,
                                 args,n);

    /* Add start buttons (make, clean, execute, debug, edit) in button box */
    
    n=0;
    XtSetArg(args[n], XtNorientation, XtorientHorizontal); n++;
    ButtonBoxW = XtCreateManagedWidget("ButtonBoxW", boxWidgetClass, paned,
				 args,n);

    AddButton("AboutW",AboutW,About);
    AddButton("MakeW",MakeW,Make);
    AddButton("CleanW",CleanW,Clean);
    AddButton("ExecuteW",ExecuteW,Execute);
    AddButton("EditW",EditW,Edit);
    AddButton("DebugW",DebugW,Debug);
    AddButton("ProgCleanW",ProgCleanW,ProgClean);
    AddButton("QuitW",QuitW,Quit);

    
    /* Add dialog lines in one big box (BoxW) */
    
    n=0;
    XtSetArg(args[n], XtNorientation, XtorientVertical); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNvSpace, 0); n++;
    BoxW = XtCreateManagedWidget("BoxW", boxWidgetClass, paned, args,n);

    /* Check if command strings have valid values */
    
    checkstring(app_resources.makeS,"makeS");
    checkstring(app_resources.cleanS,"cleanS");
    checkstring(app_resources.progClearS,"progClearS");
    checkstring(app_resources.executeS,"executeS");
    checkstring(app_resources.editS,"editS");
    checkstring(app_resources.debugS,"debugS");

    /* Init dialog strings */
    
    ProgS=XtMalloc(BUFSIZ);sprintf(ProgS,"%s",argc>1?argv[1]:"");
    ArchS=XtMalloc(BUFSIZ);sprintf(ArchS,"%s",argc>2?argv[2]:"");
    MachS=XtMalloc(BUFSIZ);sprintf(MachS,"%s",argc>3?argv[3]:"");
    OptsS=XtMalloc(BUFSIZ);sprintf(OptsS,"%s",argc>4?argv[4]:"");
    InptS=XtMalloc(BUFSIZ);sprintf(InptS,"(input for the running program)");
    getwd(cwd);
    ProjS=cwd;				/* Share Directory string	*/
    textbuf=XtMalloc(BUFSIZ);		/*  with file selector!		*/
    sprintf(projpath,"%s",cwd);
    sprintf(progpath,"%s/msc/",projpath);
    sprintf(progname,"%s",ProgS);
    sprintf(archpath,"%s/imp/",projpath);
    sprintf(archname,"%s",ArchS);

    AddBox("ProjW",&ProjW,&LabelProjW,&EnterProjW,projpath,File,PROJMODE);
    AddBox("ProgW",&ProgW,&LabelProgW,&EnterProgW,progname,File,PROGMODE);
    AddBox("ArchW",&ArchW,&LabelArchW,&EnterArchW,archname,File,ARCHMODE);
    AddBox("MachW",&MachW,&LabelMachW,&EnterMachW,MachS,NULL,0);
    AddBox("OptsW",&OptsW,&LabelOptsW,&EnterOptsW,OptsS,NULL,0);
    AddBox("InptW",&InptW,&LabelInptW,&EnterInptW,InptS,NULL,0);

    
    /* Add Logfile display */
    
    n=0;
    loglen=(XawTextPosition)strlen(AboutString);
    XtSetArg(args[n], XtNstring, AboutString); n++;
    XtSetArg(args[n], XtNinsertPosition, loglen); n++;
    XtSetArg(args[n], XtNdisplayCaret, True); n++;
    XtSetArg(args[n], XtNeditType, XawtextRead); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    LogW = XtCreateManagedWidget("LogW", asciiTextWidgetClass, paned,
				    args,n);
    /* "About"-popup */
    
    n = 0;
    AboutPopupShell = XtCreatePopupShell("About xmsp",
					 transientShellWidgetClass,
					 toplevel, args, n);
    n = 0;
    XtSetArg(args[n], XtNlabel, AboutString); n++;
    AboutPopup = XtCreateManagedWidget("AboutPopup", commandWidgetClass,
				   AboutPopupShell,
				   args, n);
    XtAddCallback(AboutPopup, XtNcallback, PopdownAbout, NULL);

    /* Start it all, set titles */
    
    XtRealizeWidget(toplevel);
    display = XtDisplay(toplevel);
    XStoreName(display, XtWindow(toplevel), WindowTitle);
    XSetIconName(display, XtWindow(toplevel), IconTitle);
    watch = XCreateFontCursor(display, XC_watch);

    /* Create PTYs to communicate with child processes */

    create_ptys();

    XtAppMainLoop(app_con);        
}

/*
 * Add a box widget containing a label and a data entry field
 * (the Action Procedures are already defined in the fallback resources
 * so we don't need them here!)
 * Use the given name to name the widgets accordingly
 * Use command button for description instead of label if callback supplied
 * Set mode (prog/proj/arch) as callback value
 */
void AddBox(name,W,LabelW,EnterW,string,callback,mode)
char   *name;
Widget *W, *LabelW, *EnterW;
char   *string;
XtCallbackProc callback;
int	mode;
{
    int  n;
    Arg  args[10];
    char s[BUFSIZ];
    
    n=0;
    XtSetArg(args[n], XtNorientation, XtorientHorizontal); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNvSpace, 3); n++;
    *W = XtCreateManagedWidget(name, boxWidgetClass, BoxW,
			       args,n);
    n=0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNjustify, XtJustifyLeft); n++;
    sprintf(s,"Label%s",name);
    if (callback) {
	*LabelW = XtCreateManagedWidget(s, commandWidgetClass, *W,
					args,n);
	XtAddCallback(*LabelW, XtNcallback, callback, (XtPointer)mode);
    } else {
	*LabelW = XtCreateManagedWidget(s, labelWidgetClass, *W,
					args,n);
    };
    n=0;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg(args[n], XtNjustify, XtJustifyLeft); n++;
    XtSetArg(args[n], XtNstring, string); n++;
    XtSetArg(args[n], XtNinsertPosition, strlen(string)); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit); n++;  /* Text entry OK   */
    sprintf(s,"Enter%s",name);
    *EnterW = XtCreateManagedWidget(s, asciiTextWidgetClass, *W,
				    args,n);

}


void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit(0);
}


void AddLog(s)
char *s;
{
    int  n;
    Arg  args[10];
    XawTextBlock    tb;
    XawTextPosition pos;

    XtSetArg(args[0], XtNeditType, XawtextEdit);	/* Enable editing  */
    XtSetValues(LogW,args,1);
    
    tb.firstPos = 0;
    tb.length   = strlen(s);
    tb.ptr      = s;
    tb.format   = FMT8BIT;
    XawTextReplace(LogW,loglen,loglen,&tb);		/* Insert new text */

    loglen=loglen+tb.length;				/* Update length   */
    XawTextSetInsertionPoint(LogW,loglen);		/*  and display	   */
    
    XtSetArg(args[0], XtNeditType, XawtextRead);	/* Disable editing */
    XtSetValues(LogW,args,1);
    

}


void HandleAddLog(master, source, id)
XtPointer master;
int       *source;
XtInputId *id;
{
    int  n;
    Arg  args[10];
    XawTextBlock    tb;
    XawTextPosition pos;

    while (fgets(textbuf, BUFSIZ-1, ptyfp)) {
	AddLog(textbuf);
    }
}


void StartProcess(s)
char *s;
{
    char  *argv[10];
    struct termio Termio;
    int    pid;
    int    pgrp;
    int	   retval;
    char  *p,*q;
    int    i;

    {char p[BUFSIZ*3];
     sprintf(p,"> %s\n",s);
     AddLog(p);
    }

    childpid = fork();
    if (childpid == -1) {
        perror("xmsp error: cannot fork process");
        exit(1);
    };
    if (childpid) {
	return;			/* We're the parent process, OK	*/
    };

    
    /*
     * Child : close master side of pty
     *         redirect stdin, stdout, stderr to pty
     *         unbuffer output data
     *         exec with arguments
     */
    close(master);

    /*
     * Modify local and output mode of slave pty
     */
    ioctl(slave, TCGETA, &Termio);
    Termio.c_lflag &= ~ECHO;        /* No echo */
    Termio.c_oflag &= ~ONLCR;       /* Do not map NL to CR-NL on output */
    ioctl(slave, TCSETA, &Termio);

    dup2(slave, 0);
    dup2(slave, 1);
    dup2(slave, 2);
    if (slave > 2)
      close(slave);
    fcntl(1, F_SETFL, FAPPEND);
    setbuf(stdout, NULL);

    /*
     * Set our process group to that of the terminal,
     * so we can change the group of the terminal.
     */
    ioctl(0, TIOCGPGRP, &pgrp);
    setpgrp(0, pgrp);

    /*
     * Now set the process group of the terminal and of us
     * to our process id.  This clears us from the control
     * of the other process group.
     */
    pid = getpid();
    ioctl(0, TIOCSPGRP, &pid);
    setpgrp(0, pid);


    /* don't tell me this could be done more efficiently ;-) */
    
    q = s;		/* Split command string into parts for execvp */
    i = 0;
    start_argv[i]=q;
    while (*q) {
	if (*q == ' ') {
	    while ((*q) && (*q == ' ')) {
		*q=(char)0;			/* null spaces		*/
		q++;
	    };
	    if (*q) {				/* Add new argv part if	*/
		i++;				/*  not at string end	*/
		start_argv[i]=q;
	    };
	};
	q++;
    };
    i++;
    start_argc=i;
    start_argv[i]=NULL;

    retval=execvp(start_argv[0], start_argv);
    printf("> [done] %s\n",s);			/* (never reached)	*/
    exit(1);
}


void Make(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.makeS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);

}


void Clean(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.cleanS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);
}


void ProgClean(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.progClearS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);
}


void Execute(w, client_data, call_data)
Widget w;	
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.executeS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);
}


void Edit(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.editS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);
}


void Debug(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char s[BUFSIZ*3];

    chdir(projpath);
    sprintf(s,app_resources.debugS,ProgS,ArchS,MachS,OptsS);

    StartProcess(s);
}


/*
 * Handle the enter functions (when return is pressed in data entry)
 */
void DoEnter(w,text,s)
Widget w;
char **text;
char *s;
{
    int  n;
    Arg  args[10];
    
    XtSetArg(args[0], XtNstring, text); /* Get text contents from widget */
    XtGetValues(w,args,1);

};


void EnterProj(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    DoEnter(w,&ProjS,"Proj");
    strcpy(projpath,ProjS);
    sprintf(progpath,"%s/msm/",projpath);
    sprintf(archpath,"%s/imp/",projpath);
}


void EnterProg(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    DoEnter(w,&ProgS,"Prog");
    strcpy(progname,ProgS);
}


void EnterArch(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    DoEnter(w,&ArchS,"Arch");
    strcpy(archname,ArchS);
}


void EnterMach(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    DoEnter(w,&MachS,"Mach");
}


void EnterOpts(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    DoEnter(w,&OptsS,"Opts");
}


void EnterInpt(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    int  n;
    Arg  args[10];
    
    DoEnter(w,&InptS,"Input");		/* Get input from widget	*/

    if (ptyfp)
	fprintf(ptyfp,"%s\n",InptS);	/* Send input to program via pty*/
    else
	printf("ptyfp not yet defined\n");
    
    sprintf(InptS,"");			
    XtSetArg(args[0],XtNstring, &InptS);/* Clear line for new input	*/
    XtSetValues(w,args,1);

}


int open_master()
{
    int  i, master;
    char c;

    for (c='p'; c<='s'; c++) {
        pty[8] = c;
        for (i=0; i<16; i++) {
            pty[9] = "0123456789abcdef"[i];
            if ((master = open(pty, O_RDWR)) != -1)
                return (master);
        }
    }
    fprintf(stderr, "xmsp: all ptys in use\n");
    exit(1);
}

int open_slave()
{
    int slave;

    tty[8] = pty[8];
    tty[9] = pty[9];
    if ((slave = open(tty, O_RDWR)) != -1)
        return (slave);
    fprintf(stderr, "open: cannot open slave pty %s", tty);
    exit(1);
}

void create_ptys()
{
    int           fd;                   /* file descriptor of controlling tty*/

    /*
     * Clear controlling tty.  Do this now, so that open_slave and
     * open_master will cause the selected pty to become the
     * controlling tty.
     */
    if ((fd = open("/dev/tty", O_RDWR)) > 0) {
        ioctl(fd, TIOCNOTTY, 0);
        close(fd);
    }

    master = open_master();
    slave = open_slave();

    /*
     * Parent : close the slave side of pty
     *          close stdin and stdout
     *          set the file descriptor to nonblocking mode
     *          open file pointer with read/write access
     *          set line buffered mode
     *          register input with X
     */
/*    close(slave);*/
/*    close(0);*/
/*    close(1);*/
    fcntl(master, F_SETFL, FNDELAY);
    ptyfp = fdopen(master, "r+");
    setlinebuf(ptyfp);
    input = XtAppAddInput(app_con, master, XtInputReadMask,
			  HandleAddLog, NULL);
}


/*  About-info-popup
 */
void About(w, client_data, call_data)
    Widget    w;
    XtPointer client_data;
    XtPointer call_data;
{
    Arg 	args[10];
    Cardinal	n;
    Position	x, y, x_offset;
    Dimension	width,mywidth,height,myheight;

    XDefineCursor(display, XtWindow(paned), watch);
    XFlush(display);

/*    n=0;
    XtSetArg(args[n], XtNwidth, width); n++;
    XtSetArg(args[n], XtNheight, height); n++;
    XtGetValues(paned, args, n);

    n=0;
    XtSetArg(args[n], XtNwidth, mywidth); n++;
    XtSetArg(args[n], XtNheight, myheight); n++;
    XtGetValues(AboutPopupShell, args, n);
*/
    XtTranslateCoords(paned, 0, 0, &x, &y);

/*    x = x + (Dimension) ((width - mywidth)/2);		/* Center popup */
/*    y = y + (Dimension) ((height - myheight)/2);*/

    n = 0;
    XtSetArg(args[n], XtNx, x);					n++;
    XtSetArg(args[n], XtNy, y);					n++;
    XtSetValues(AboutPopupShell, args, n);
    XtPopup(AboutPopupShell, XtGrabNonexclusive);

}


static void PopdownAbout(w, popupshell, call_data)
    Widget w;
    Widget popupshell;
    XtPointer *call_data;
{
    XtPopdown(AboutPopupShell); 
    XUndefineCursor(display, XtWindow(paned));
}
