/*
 *  (adapted from xdbx)
 *
 *  changeDir():	Record the current working directory.
 *  InList():		Select files to be displayed in the menu.
 *  ScanDir():		Scan the directory and record selected filenames.
 *  DisplayMenuFile():	Callback for the file menu.
 *  CancelFileMenu():	Pop down the file menu.
 *  SetUpFileMenu():	Create the file menu popupshell.
 *  UpdateFileMenu():	Update entries in the file menu.
 *  File():		Command callback for the 'file' command button.
 *
 */

#include "xmsp.h"


#define MAXARGS         20              /* max number of args */
#define MAXCOLUMNS      8               /* max number of columns in file menu*/
#define LINESIZ		BUFSIZ
#define FILES_PER_COL   10              /* # of files per column in file menu*/
#define LASTCH(s)       (s[strlen(s)-1])
#define SECLASTCH(s)    (s[strlen(s)-2])
typedef struct dirent   Directory;

char		cwd[BUFSIZ];		/* current working directory of dbx */
static char	fileMenuDir[BUFSIZ];	/* current directory of file menu */
static char  	**filelist; 		/* list of file names in fileMenu */
static int	nfiles = 0;		/* number of files in filelist */
static Widget	popupshell,		/* parent of popup */
		popup, 			/* vpane widget containing file menu */
		fileMenu, 		/* list widget as file menu */
		fileMenuLabel, 		/* label widget as file menu label */
                cancelButton;		/* cancel/directory select */

static int	FileSelectMode=0;	/* mode (prog,proj,arch) */

void		File(), UpdateFileMenu();


/* Set string of text widget */

void UpdateString(w,s)
Widget w;
char  *s;
{
    Arg  args[2];
    
    XtSetArg(args[0], XtNstring, s);
    XtSetValues(w,args,1);
    XtSetArg(args[0], XtNinsertPosition, strlen(s));
    XtSetValues(w,args,1);
    
};


/*  Change working directory to 'dir'.
 *  modify global variable, cwd, to keep track of current working directory.
 */
static void changeDir(dir)
char *dir;
{
    char command[LINESIZ];

    int i;

    if (strcmp(dir, "./") == NULL) 
	return;
    if ((dir[0] == '/') || (dir[0] == '~')) 
	strcpy(cwd, dir);
    if (strcmp(dir, "../") == NULL) {
	for (i=strlen(cwd); cwd[i] != '/' && i > 0; i--);
	cwd[i] = '\0';
	if (strcmp(cwd, "") == NULL)
	    strcpy(cwd, "/");
    }
    else {
	sprintf(cwd, "%s/%s", cwd, dir);
	LASTCH(cwd) = '\0';
    }
/*    sprintf(command, "> set project directory %s\n", dir);
    AddLog(command);
 */
}


/*  Determines if a directory entry should appear in the file menu. 
 *  The files included in the menu are :
 *    ..  (parent directory)
 *    directories
 *    text files 
 *    executable files
 */
static int InList(entry)
Directory *entry;
{
    char pathname[LINESIZ];
    struct stat statbuf;

    if (strcmp(entry->d_name, ".") == NULL || 	/* ignore current directory */
	LASTCH(entry->d_name) == '~' ||		/* ignore Emacs backup files */
	(LASTCH(entry->d_name) == 'o' && SECLASTCH(entry->d_name) == '.'))
						/* ignore object files */
	return False;
    if ((strcmp(entry->d_name, "..") == NULL ) && /* ignore ".." in archmode */
	 (FileSelectMode == ARCHMODE))
      return False;
    if ((entry->d_name[0] == '.') && (entry->d_name[1] != '.'))
	return False;				/* ignore hidden files */
    
    if (strcmp(cwd, "")) 			/* give full path name */
    	sprintf(pathname, "%s/%s", cwd, entry->d_name);
    else
    	strcpy(pathname, entry->d_name);
    if (stat(pathname, &statbuf) == -1) 
	return False;

    /* is directory -> OK */
    
    if (statbuf.st_mode & S_IFDIR) {
	if (FileSelectMode == ARCHMODE) {/* Arch.Mode -> show Dir w/o "/"  */
	    return True;
	};
	strcat(entry->d_name, "/");
	++(entry->d_namlen);
	if (FileSelectMode != PROJMODE)	/* directories only in Proj.Mode */
	  return False;
	else
	  return True;
    }

    if ((FileSelectMode == PROJMODE) ||
	(FileSelectMode == ARCHMODE))	/* Show only directories in ProjMode */
      return False;			/* (and dirs as files in ArchMode)   */

    if ((FileSelectMode == PROGMODE) &&	/* cut ".msm" from program files */
	(strlen(entry->d_name)>4)) {
	char *p = entry->d_name + strlen(entry->d_name)-4;
	if (strcmp(p,".msm")==NULL) {
	    *p = '\0';
	    entry->d_namlen = entry->d_namlen - 4;
	};
    };

    return True;
}


/*  Scans the working directory for files selected by InList(), sorted
 *  alphabetically, and stored in an array of pointers to directory
 *  entries called namelist.
 *  The names of the selected files are stored in filelist.
 */
static void ScanDir(dir)
char *dir;
{
    extern 	alphasort();
    Directory   **namelist;
    int		i, j;
    char	s[BUFSIZ];

    nfiles = scandir(dir, &namelist, InList, alphasort);
    if (nfiles == -1) {
	sprintf("scandir: cannot open %s\n", dir);
	AddLog(s);
	return;
    }
    if (filelist) {
	for (i=0; filelist[i]; i++)
	    XtFree(filelist[i]);
	XtFree(filelist);
    }
    filelist = (char **) XtMalloc((nfiles+1) * sizeof(char *));
    i = 0;
    for (j=0; j<nfiles; j++) {
	filelist[i++] = XtNewString(namelist[j]->d_name);
    	XtFree(namelist[j]);
    }
    filelist[i++] = NULL;
    XtFree(namelist);
    return;
}
    

/*  Callback for the fileMenu list widget.
 *  >  if the selected item is a directory, display contents of that directory.
 *  >  if the selected item is a readable file, select the file.
 */
/* ARGSUSED */
static void DisplayMenuFile(w, popupshell, call_data)
    Widget w;
    Widget popupshell;
    XawListReturnStruct *call_data;
{
    char string[LINESIZ], *filename, command[LINESIZ];

    XtPopdown(popupshell); 
    XUndefineCursor(display, XtWindow(paned));
    filename = call_data->string;
    if (filename == NULL) return;
    if (LASTCH(filename) == '/') {			/* enter directory */
	changeDir(filename);
	XtDestroyWidget(popupshell);
	UpdateFileMenu();				/* create new menu */
	File(NULL,NULL,NULL);				/* pop it up */
    }
    else {
	strcpy(string, filename);			/* strip "*" off */
	if (LASTCH(string) == '*') {			/*  executable */
	    LASTCH(string) = '\0';
	};
	if (LASTCH(string) == '/') {			/* dito "/" dir */
	    LASTCH(string) = '\0';
	};
	switch (FileSelectMode) {			/* update strings */
	case PROGMODE: {				/*  according to mode*/
	    char *p = string + strlen(string);
	    while ((p>string) && (*p != '/'))
	      p--;
	    if (p>string) {
		*p='\0';
		strcpy(progname,p+1);	/* [progpath = projpath/msm always] */
	    } else {
		strcpy(progname,string);
	    };
	    UpdateString(EnterProgW,progname);
/*	    sprintf(command,"> select program %s\n",progname);
	    AddLog(command);
 */
	    break;}
	case PROJMODE: {
	    printf("projmode and no directory !!!\n");
	    break;}
	case ARCHMODE: {
	    char *p = string + strlen(string);
	    while ((p>string) && (*p != '/'))
	      p--;
	    if (p>string) {
		*p='\0';			/* (can't change archpath) */
		strcpy(archname,p+1);
	    } else {
		strcpy(archname,string);
	    };
	    UpdateString(EnterArchW,archname);
/*	    sprintf(command,"> select architecture %s\n",archname);
	    AddLog(command);
 */
	    break;}
	default: printf("Unknown FileSelectMode!\n");
	};
    }

}


/*  Callback to popdown the file menu
 */
/* ARGSUSED */
static void CancelFileMenu(w, popupshell, call_data)
    Widget w;
    Widget popupshell;
    caddr_t call_data;
{
    char s[BUFSIZ];
    
    XtPopdown(popupshell);
    if (FileSelectMode == PROJMODE) {
/*	sprintf(s,"> Select directory %s\n",cwd);
	AddLog(s);*/
	sprintf(projpath,cwd);
	UpdateString(EnterProjW,projpath);
	sprintf(progpath,"%s/msm/",cwd);
	sprintf(archpath,"%s/imp/",cwd);
    };
    XUndefineCursor(display, XtWindow(paned));
    
}


/*  Creates a popup shell with its child being a vpane widget containing
 *  a file menu label, a file menu containing file names returned from 
 *  ScanDir(), and a cancel command button.
 *  When an item in the list is selected, DisplayMenuFile is called.
 */
void SetUpFileMenu(dir) 
char *dir;
{
    Arg 	args[MAXARGS];
    Cardinal	n;
    char	menulabel[LINESIZ];
    int		ncolumns;

    n = 0;
    popupshell = XtCreatePopupShell("File Directory",transientShellWidgetClass,
				    toplevel, args, n);

    n = 0;
    popup = XtCreateManagedWidget("popup", panedWidgetClass, popupshell,
				  args, n);
    ScanDir(dir);
    strcpy(fileMenuDir, dir);

    n = 0;
    switch (FileSelectMode) {
    case PROJMODE:
	if (strlen(dir)+6>strlen("select current as project directory"))
	  sprintf(menulabel, "%s", dir);
	else
	  sprintf(menulabel, "%s%s",dir,	/* long enough to show "sel."*/
		  "                                    "+strlen(dir));
	break;
    case PROGMODE:
	sprintf(menulabel, "   Select a Program   ");
	break;
    case ARCHMODE:
	sprintf(menulabel, "   Select an Architecture   ");
	break;
    default: printf("Unknown FileSelectMode %d!\n",FileSelectMode);
    }
    XtSetArg(args[n], XtNlabel, (XtArgVal) menulabel); 			n++;
    XtSetArg(args[n], XtNjustify, (XtArgVal) XtJustifyCenter);          n++;
    fileMenuLabel = XtCreateManagedWidget("fileMenuLabel", labelWidgetClass,
                                          popup, args, n);

    n = 0;
    ncolumns = nfiles/FILES_PER_COL + 1;
    ncolumns = MIN(ncolumns, MAXCOLUMNS);
    XtSetArg(args[n], XtNlist, filelist);				n++;
    XtSetArg(args[n], XtNverticalList, True);				n++;
    XtSetArg(args[n], XtNdefaultColumns, (XtArgVal) ncolumns);		n++;
    fileMenu = XtCreateManagedWidget("fileMenu", listWidgetClass, 
				     popup, args, n);
    XtAddCallback(fileMenu, XtNcallback, DisplayMenuFile, popupshell);

    n = 0;
    XtSetArg(args[n], XtNresize, False);				n++;
    cancelButton = XtCreateManagedWidget("cancelButton", commandWidgetClass,
					 popup, args, n);
    XtAddCallback(cancelButton, XtNcallback, CancelFileMenu, popupshell);

/*    DisableWindowResize(fileMenuLabel);
    DisableWindowResize(cancelButton);*/
}


/*  This routine is called when there is a a change in current directory.
 *  It destroys the existing popup shell and creates a new file menu based
 *  on the new current directory.  A new directory list is created.
 */
static void UpdateFileMenu()
{
    SetUpFileMenu(cwd);
}


/*  File command button callback.
 *  (client_data = fileselectmode, set to !=0 on 1st call when used as direct
 *   callback for a button (prog/proj/arch). set to 0 when changing the
 *   directory and displaying the new contents [no cwd=projpath set then!]
 */
void File(w, client_data, call_data)
    Widget    w;
    XtPointer client_data;
    XtPointer call_data;
{
    Arg 	args[MAXARGS];
    Cardinal	n;
    Position	x, y, x_offset;
    Dimension	fileMenu_width, fileMenuLabel_width, border_width,
		width, dialog_width;

    
/*    {char s[BUFSIZ]; char *nn="NULL\0Prog\0Proj\0Arch\0";
     sprintf(s,"FileSelectMode %s (%d), client_data %d\n",nn+FileSelectMode*5,FileSelectMode,client_data);
     sprintf(s,"%s  proj=%s\n  prog=%s[%s]\n  arch=%s[%s]\n",s,projpath,progpath,progname,archpath,archname);
     AddLog(s);}
*/
    XDefineCursor(display, XtWindow(paned), watch);
    XFlush(display);

    if (client_data != 0) {
	FileSelectMode = (int)client_data;
	switch ((int)client_data) {	/* Set appropriate cwd */
	case PROGMODE: {		/* on 1st entry, else client_data=0 */
	    strcpy(cwd,progpath);
	    break;}
	case PROJMODE: {
	    strcpy(cwd,projpath);
	    break;}
	case ARCHMODE: {
	    strcpy(cwd,archpath);
	    break;}
	default: printf("Unknown FileSelectMode %d!\n",client_data);
	}
    }
    
/*    if (strcmp(fileMenuDir, cwd))*/	/* Always update(maybe new files etc)*/
	UpdateFileMenu();
    
    switch (FileSelectMode) {	/* Set appropriate btn label */
    case PROGMODE: {		/* (always) */
	XtSetArg(args[0], XtNlabel, "Cancel");
	XtSetValues(cancelButton,args,1);
	break;}
    case PROJMODE: {
	XtSetArg(args[0], XtNlabel, "Select Current as Project Directory");
	XtSetValues(cancelButton,args,1);
	break;}
    case ARCHMODE: {
	XtSetArg(args[0], XtNlabel, "Cancel");
	XtSetValues(cancelButton,args,1);
	break;}
    default: printf("Unknown FileSelectMode %d!\n",FileSelectMode);
    }

    n = 0;
    XtSetArg(args[n], XtNwidth, &fileMenu_width);			n++;
    XtSetArg(args[n], XtNborderWidth, &border_width);		n++;
    XtGetValues(fileMenu, args, n);

    n = 0;
    XtSetArg(args[n], XtNwidth, &fileMenuLabel_width);		n++;
    XtGetValues(fileMenuLabel, args, n);

    n = 0;
    XtSetArg(args[n], XtNwidth, &dialog_width);			n++;
    XtGetValues(paned, args, n);

    width = MAX(fileMenu_width, fileMenuLabel_width);

    x_offset = (Position) 0;  /*((dialog_width - width - border_width)/2);*/
    XtTranslateCoords(paned, x_offset, 0, &x, &y);

    x = MAX(0, x);
    y = MAX(0, y);

    n = 0;
    XtSetArg(args[n], XtNx, x);					n++;
    XtSetArg(args[n], XtNy, y);					n++;
    XtSetValues(popupshell, args, n);
    XtPopup(popupshell, XtGrabNonexclusive);

/*    AddLog("Select a file or directory");*/
}

