/****************************************************************************
 *
 *  xdbx - X Window System interface to dbx
 *
 *  Copyright 1989, 1990 The University of Texas at Austin
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of The University of Texas
 *  not be used in advertising or publicity pertaining to distribution of
 *  the software without specific, written prior permission.  The
 *  University of Texas makes no representations about the suitability of
 *  this software for any purpose.  It is provided "as is" without express
 *  or implied warranty.
 *
 *  THE UNIVERSITY OF TEXAS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *  SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TEXAS BE LIABLE FOR ANY
 *  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 *  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 *  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  Author:  	Po Cheung, The University of Texas at Austin
 *  Created:   	March 10, 1989
 *
 *****************************************************************************/

/*  windows.c:
 *
 *    CreateTitleBar() :	Create title bar.
 *    CreateMessageWindow() :	Create message window.
 *    CreateDisplayWindow() :	Create display window.
 *    CreateSubWindows() :	Create the subwindows.
 *    UpdateFileLabel() :	Update file label.
 *    UpdateLineLabel() :	Update line label.
 *    UpdateMessageWindow() :	Update message window.
 *
 *
 *  Changes by Stefan Haenssgen:
 *
 *  07-19-91    Modified to use SWindow instead of sourceWindow etc
 *		Allocate space for swindow in CreateSubWindows
 *  07-30-91	Pass swindow as parameter to CreateSourceWindow()
 *  07-31-91    Use a_swindow for globally active one and pass
 *               swindow as parameter for calls that affect just one
 *               certain window (such as action procedures etc)
 *		Modified CreateFileLabel, CreateLineLabel, CreateFileWindow,
 *		 UpdateFileLabel, UpdateLineLabel to take swindow as
 *		 parameter
 *  08-01-91	Added activeButton to FileWindow to handle des/activation
 *		 of source code windows
 *		Use CreateActiveButton from swindow.c
 *		Moved CreateFileWindow, CreateLineLabel, CreateFileLabel
 *		 to swindow.c
 *
 */

#include "global.h"

Widget	messageWindow,			/* window for displaying messages */
	separator,			/* separator in vpane */
	displayWindow;			/* area for displaying variables */


/*
 *  Private routines for creating various subwindows for xdbx.
 */

static void CreateMessageWindow(parent)
Widget parent;
{
    Arg 	args[MAXARGS];
    Cardinal 	n;

    n = 0;
    XtSetArg(args[n], XtNlabel, (XtArgVal) ""); 			n++;
    XtSetArg(args[n], XtNjustify, (XtArgVal) XtJustifyLeft);          	n++;
    XtSetArg(args[n], XtNshowGrip, (XtArgVal) False);			n++;
    messageWindow = XtCreateManagedWidget("messageWindow", labelWidgetClass,
					  parent, args, n);
}

/*  Create a window for displaying variables as specified by the display
 *  command in dbx.
 */
static void CreateDisplayWindow(parent)
Widget parent;
{
    Arg 	args[MAXARGS];
    Cardinal 	n;

    n = 0;
    XtSetArg(args[n], XtNborderWidth, (XtArgVal) 0);                    n++;
    XtSetArg(args[n], XtNmin, (XtArgVal) 2); 				n++;
    XtSetArg(args[n], XtNmax, (XtArgVal) 2); 				n++;
    XtSetArg(args[n], XtNshowGrip, (XtArgVal) False);			n++;
    separator = XtCreateWidget("", labelWidgetClass, parent, args, n);

    n = 0;
    XtSetArg(args[n], XtNeditType, (XtArgVal) XawtextRead);		n++;
    displayWindow = XtCreateWidget("displayWindow", asciiTextWidgetClass, 
				   parent, args, n);

    if (app_resources.displayWindow) {
	XtManageChild(separator);
	XtManageChild(displayWindow);
    }
}


/*  PUBLIC ROUTINES */
/*
 *  Top level function for creating all the xdbx subwindows.
 */
void CreateSubWindows(parent)
Widget parent;
{
    Widget	vpane;		/* outer widget containing various subwindows*/
    Arg 	args[MAXARGS];
    Cardinal 	n;

    n = 0;
    vpane = XtCreateManagedWidget("vpane", panedWidgetClass, parent, args, n);

    /* Allocate & Initialize a source code window */

    a_swindow = CreateSWindow(vpane,FALSE);	/* add non-closeable SWindow */
    CreateMessageWindow(vpane);
    CreateCommandPanel(vpane);
    CreateDialogWindow(vpane);
#ifndef BSD
    CreateDisplayWindow(vpane);
#endif
} 

/*
 *  Routines for updating fields for the filename and line number
 *  in the file window, and the execution status in the message window.
 */

void UpdateFileLabel(string, swindow)
char *string;
SWindow *swindow;
{
    Arg 	args[MAXARGS];
    Cardinal 	n;

    n = 0;
    XtSetArg(args[n], XtNlabel, (XtArgVal) string);        		n++;
    XtSetValues(swindow->fileLabel, args, n);
}

void UpdateLineLabel(line, swindow)
Cardinal line;
SWindow *swindow;
{
    Arg 	args[MAXARGS];
    Cardinal 	n;
    char 	string[10];

    n = 0;
    if (line > 0)
    	sprintf(string, "%d", line);
    else
	strcpy(string, "");
    XtSetArg(args[n], XtNlabel, (XtArgVal) string);        	n++;
    XtSetValues(swindow->lineLabel, args, n);
}

void UpdateMessageWindow(format, arg)
char *format, *arg;
{
    char 	message[LINESIZ], string[LINESIZ];
    Arg 	args[MAXARGS];
    Cardinal 	n;

    strcpy(message, "  ");
    sprintf(string, format, arg);
    strcat(message, string);
    n = 0;
    XtSetArg(args[n], XtNlabel, (XtArgVal) message);		n++;
    XtSetValues(messageWindow, args, n);
}

void ClearMessageWindow()
{
    Arg 	args[MAXARGS];
    Cardinal 	n;

    n = 0;
    XtSetArg(args[n], XtNlabel, (XtArgVal) "");			n++;
    XtSetValues(messageWindow, args, n);
}

