#include"sym/SUN4/HEADERS.SUN4.h"

#ifndef DEFINITION_General
#include"sym/SUN4/General.SUN4.h"
#endif

/*& General.c */

#ifndef DEFINITION_SysCalls
#include"sym/SUN4/SysCalls.SUN4.h"
#endif

/*& SysCalls.c */

#ifndef DEFINITION_Memory
#include"sym/SUN4/Memory.SUN4.h"
#endif

LONGCARD Memory_MemoryUsed;

 struct t_8 {
struct t_8 *v_7;
};
static struct t_8 v_7;

 struct t_9 {
struct t_9 *v_8;
};
plural static struct t_9 v_8;

plural static t_7();
#define MinSizeSmallBlock	4
#define MaxSizeSmallBlock	62
#define MinSizeLargeBlockLog	6
#define MaxSizeLargeBlockLog	24
#define PoolSize	10240
#define NoMoreSpace	-1
typedef struct MemoryS__1 *tBlockPtr;
typedef struct MemoryS__1 {
    tBlockPtr Successor;
    LONGINT Size;
} tBlock;
typedef LONGCARD tSmallBlockRange;
typedef LONGCARD tLargeBlockRange;
static struct MemoryS__2 {
    ADDRESS A[MaxSizeSmallBlock - MinSizeSmallBlock + 1];
} SmallChain;
static struct MemoryS__3 {
    ADDRESS A[MaxSizeLargeBlockLog - MinSizeLargeBlockLog + 1];
} LargeChain;
static ADDRESS PoolFreePtr;
static ADDRESS PoolEndPtr;
static tSmallBlockRange i;
static tLargeBlockRange j;


plural static t_7()
{
_ParProcStart_(t_7);
/* pi */_ParProcEnd_(t_7);
}
ADDRESS
Memory_Alloc(ByteCount)
LONGINT ByteCount;
{
  tBlockPtr BlockPtr, CurrentBlock, PreviousBlock, BestBlock, PredecessorBlock;
  CARDINAL ChainNumber;
  LONGINT CurrentBlockSize, BestBlockSize;
  tLargeBlockRange j;

  ByteCount = (LONGINT )((BITSET )(ByteCount + General_MaxAlign - 1) & General_AlignMasks.A[General_MaxAlign]);
  if (ByteCount <= MaxSizeSmallBlock) {
    if (ByteCount < MinSizeSmallBlock) {
      ByteCount = MinSizeSmallBlock;
    }
    if (SmallChain.A[ByteCount - 4] != NIL) {
      BlockPtr = (tBlockPtr)SmallChain.A[ByteCount - 4];
      SmallChain.A[ByteCount - 4] = (ADDRESS)BlockPtr->Successor;
      return (ADDRESS)BlockPtr;
    } else {
      if ((LONGINT )(PoolEndPtr - (LONGCARD)PoolFreePtr) < ByteCount) {
        if (PoolEndPtr - (LONGCARD)PoolFreePtr >= MinSizeSmallBlock) {
          Memory_Free((LONGINT)(LONGINT )(PoolEndPtr - (LONGCARD)PoolFreePtr), (ADDRESS)PoolFreePtr);
        }
        PoolFreePtr = Memory_Alloc((LONGINT)PoolSize);
        PoolEndPtr = PoolFreePtr + PoolSize;
      }
      INC1(PoolFreePtr, (LONGCARD)(ADDRESS )ByteCount);
      return PoolFreePtr - (LONGCARD)(ADDRESS )ByteCount;
    }
  } else {
    ChainNumber = General_Log2((LONGINT)ByteCount);
    CurrentBlock = (tBlockPtr)LargeChain.A[ChainNumber - 6];
    PreviousBlock = (tBlockPtr)ADR(LargeChain.A[ChainNumber - 6]);
    BestBlock = NIL;
    BestBlockSize = 1000000000;
    while (CurrentBlock != NIL) {
      CurrentBlockSize = CurrentBlock->Size;
      if (CurrentBlockSize >= ByteCount) {
        if (CurrentBlockSize == ByteCount) {
          PreviousBlock->Successor = CurrentBlock->Successor;
          return (ADDRESS)CurrentBlock;
        }
        if (CurrentBlockSize < BestBlockSize) {
          BestBlock = CurrentBlock;
          BestBlockSize = CurrentBlockSize;
          PredecessorBlock = PreviousBlock;
        }
      }
      PreviousBlock = CurrentBlock;
      CurrentBlock = CurrentBlock->Successor;
          }
    if (BestBlock != NIL) {
      PredecessorBlock->Successor = BestBlock->Successor;
      if (BestBlockSize - ByteCount >= MinSizeSmallBlock) {
        Memory_Free((LONGINT)BestBlockSize - ByteCount, (ADDRESS)(ADDRESS )BestBlock + (LONGCARD)(ADDRESS )ByteCount);
      }
      return (ADDRESS)BestBlock;
    }
    for (j = ChainNumber + 1; j <= MaxSizeLargeBlockLog; j += 1) {
      CurrentBlock = (tBlockPtr)LargeChain.A[j - 6];
      if (CurrentBlock != NIL) {
        LargeChain.A[j - 6] = (ADDRESS)CurrentBlock->Successor;
        if (CurrentBlock->Size - ByteCount >= MinSizeSmallBlock) {
          Memory_Free((LONGINT)CurrentBlock->Size - ByteCount, (ADDRESS)(ADDRESS )CurrentBlock + (LONGCARD)(ADDRESS )ByteCount);
        }
        return (ADDRESS)CurrentBlock;
      }
    }
    if (ByteCount < PoolSize) {
      if ((LONGINT )(PoolEndPtr - (LONGCARD)PoolFreePtr) < ByteCount) {
        if (PoolEndPtr - (LONGCARD)PoolFreePtr >= MinSizeSmallBlock) {
          Memory_Free((LONGINT)(LONGINT )(PoolEndPtr - (LONGCARD)PoolFreePtr), (ADDRESS)PoolFreePtr);
        }
        PoolFreePtr = Memory_Alloc((LONGINT)PoolSize);
        PoolEndPtr = PoolFreePtr + PoolSize;
      }
      INC1(PoolFreePtr, (LONGCARD)(ADDRESS )ByteCount);
      return PoolFreePtr - (LONGCARD)(ADDRESS )ByteCount;
    } else {
      BlockPtr = (tBlockPtr)SysCalls_Alloc((LONGINT)ByteCount);
      if ((LONGINT )BlockPtr == NoMoreSpace) {
        return (ADDRESS)NIL;
      } else {
        INC1(Memory_MemoryUsed, ByteCount);
        return (ADDRESS)BlockPtr;
      }
    }
  }
}

void
Memory_Free(ByteCount, a)
LONGINT ByteCount;
ADDRESS a;
{
  tBlockPtr BlockPtr;
  tLargeBlockRange ChainNumber;

  ByteCount = (LONGINT )((BITSET )(ByteCount + General_MaxAlign - 1) & General_AlignMasks.A[General_MaxAlign]);
  BlockPtr = (tBlockPtr)a;
  if (ByteCount <= MaxSizeSmallBlock) {
    if (ByteCount < MinSizeSmallBlock) {
      ByteCount = MinSizeSmallBlock;
    }
    BlockPtr->Successor = (tBlockPtr)SmallChain.A[ByteCount - 4];
    SmallChain.A[ByteCount - 4] = (ADDRESS)BlockPtr;
  } else {
    ChainNumber = General_Log2((LONGINT)ByteCount);
    BlockPtr->Successor = (tBlockPtr)LargeChain.A[ChainNumber - 6];
    BlockPtr->Size = ByteCount;
    LargeChain.A[ChainNumber - 6] = (ADDRESS)BlockPtr;
  }
}

void BEGIN_Memory()
{
  static BOOLEAN has_been_called = FALSE;

  if (!has_been_called) {
    has_been_called = TRUE;

    BEGIN_General();
    BEGIN_SysCalls();

    for (i = MinSizeSmallBlock; i <= MaxSizeSmallBlock; i += 2) {
      SmallChain.A[i - 4] = (ADDRESS)NIL;
    }
    for (j = MinSizeLargeBlockLog; j <= MaxSizeLargeBlockLog; j += 1) {
      LargeChain.A[j - 6] = (ADDRESS)NIL;
    }
    PoolFreePtr = (ADDRESS)NIL;
    PoolEndPtr = (ADDRESS)NIL;
    Memory_MemoryUsed = 0;
  }
}
