#include"sym/SUN4/HEADERS.SUN4.h"

#ifndef DEFINITION_General
#include"sym/SUN4/General.SUN4.h"
#endif

/*& General.c */

#ifndef DEFINITION_Memory
#include"sym/SUN4/Memory.SUN4.h"
#endif

/*& Memory.c */

#ifndef DEFINITION_Heap
#include"sym/SUN4/Heap.SUN4.h"
#endif

LONGCARD Heap_HeapUsed;

 struct t_8 {
struct t_8 *v_7;
};
static struct t_8 v_7;

 struct t_9 {
struct t_9 *v_8;
};
plural static struct t_9 v_8;

plural static t_7();
#define PoolSize	10240
typedef struct HeapS__1 *tBlockPtr;
typedef struct HeapS__1 {
    tBlockPtr Successor;
    struct HeapS__2 {
        CHAR A[PoolSize - 1 + 1];
    } Block;
} tBlock;
static tBlockPtr BlockList;
static ADDRESS PoolFreePtr;
static ADDRESS PoolEndPtr;


plural static t_7()
{
_ParProcStart_(t_7);
/* pi */_ParProcEnd_(t_7);
}
ADDRESS
Heap_Alloc(ByteCount)
LONGINT ByteCount;
{
  tBlockPtr BlockPtr;

  ByteCount = (LONGINT )((BITSET )(ByteCount + General_MaxAlign - 1) & General_AlignMasks.A[General_MaxAlign]);
  if ((LONGINT )(PoolEndPtr - (LONGCARD)PoolFreePtr) < ByteCount) {
    BlockPtr = BlockList;
    BlockList = (tBlockPtr)Memory_Alloc((LONGINT)sizeof(tBlock));
    BlockList->Successor = BlockPtr;
    PoolFreePtr = ADR(BlockList->Block);
    PoolEndPtr = PoolFreePtr + PoolSize;
    INC1(Heap_HeapUsed, PoolSize);
  }
  INC1(PoolFreePtr, (LONGCARD)(ADDRESS )ByteCount);
  return PoolFreePtr - (LONGCARD)(ADDRESS )ByteCount;
}

void
Heap_Free()
{
  tBlockPtr BlockPtr;

  while (BlockList != NIL) {
    BlockPtr = BlockList;
    BlockList = BlockList->Successor;
    Memory_Free((LONGINT)sizeof(tBlock), (ADDRESS)BlockPtr);
      }
  PoolFreePtr = (ADDRESS)NIL;
  PoolEndPtr = (ADDRESS)NIL;
  Heap_HeapUsed = 0;
}

void BEGIN_Heap()
{
  static BOOLEAN has_been_called = FALSE;

  if (!has_been_called) {
    has_been_called = TRUE;

    BEGIN_General();
    BEGIN_Memory();

    BlockList = NIL;
    Heap_Free();
  }
}
