#include"sym/SUN4/HEADERS.SUN4.h"

#ifndef DEFINITION_General
#include"sym/SUN4/General.SUN4.h"
#endif

/*& General.c */

#ifndef DEFINITION_Memory
#include"sym/SUN4/Memory.SUN4.h"
#endif

/*& Memory.c */

#ifndef DEFINITION_DynArray
#include"sym/SUN4/DynArray.SUN4.h"
#endif


 struct t_8 {
struct t_8 *v_7;
};
static struct t_8 v_7;

 struct t_9 {
struct t_9 *v_8;
};
plural static struct t_9 v_8;

plural static t_7();
static LONGINT AlignedSize();


plural static t_7()
{
_ParProcStart_(t_7);
/* pi */_ParProcEnd_(t_7);
}
void
DynArray_MakeArray(ArrayPtr, ElmtCount, ElmtSize)
ADDRESS * ArrayPtr;
LONGINT * ElmtCount;
LONGINT ElmtSize;
{
  ElmtSize = AlignedSize((LONGINT)ElmtSize);
  switch (ElmtSize % 4) {
  case 0:;
    break;
  case 2:;
    if (ODD(*ElmtCount)) {
      INC(*ElmtCount);
    }
    break;
  case 1:;
  case 3:;
    INC1(*ElmtCount, sizeof(LONGINT) - 1 - (*ElmtCount - 1) % sizeof(LONGINT));
    break;
  }
  *ArrayPtr = Memory_Alloc((LONGINT)*ElmtCount * ElmtSize);
}

void
DynArray_ExtendArray(ArrayPtr, ElmtCount, ElmtSize)
ADDRESS * ArrayPtr;
LONGINT * ElmtCount;
LONGINT ElmtSize;
{
  ADDRESS NewPtr;
  LONGINT *Source, *Target;
  LONGINT i;

  ElmtSize = AlignedSize((LONGINT)ElmtSize);
  NewPtr = Memory_Alloc((LONGINT)*ElmtCount * ElmtSize * 2);
  Source = (LONGINT *)(*ArrayPtr);
  Target = (LONGINT *)NewPtr;
  {
    LONGINT B_1 = 1, B_2 = *ElmtCount * ElmtSize / sizeof(LONGINT);

    if (B_1 <= B_2)
      for (i = B_1;(BOOLEAN  ) 1; i += 1) {
        *Target = *Source;
        Source = (LONGINT *)(ADDRESS )((ADDRESS )Source + sizeof(LONGINT));
        Target = (LONGINT *)(ADDRESS )((ADDRESS )Target + sizeof(LONGINT));
        if (i >= B_2) break;
      }
  }
  Memory_Free((LONGINT)*ElmtCount * ElmtSize, (ADDRESS)*ArrayPtr);
  *ArrayPtr = NewPtr;
  INC1(*ElmtCount, *ElmtCount);
}

void
DynArray_ReleaseArray(ArrayPtr, ElmtCount, ElmtSize)
ADDRESS * ArrayPtr;
LONGINT * ElmtCount;
LONGINT ElmtSize;
{
  ElmtSize = AlignedSize((LONGINT)ElmtSize);
  Memory_Free((LONGINT)*ElmtCount * ElmtSize, (ADDRESS)*ArrayPtr);
}

static LONGINT
AlignedSize(ElmtSize)
LONGINT ElmtSize;
{
  LONGINT Align;

  if (ElmtSize >= General_MaxAlign) {
    Align = General_MaxAlign;
  } else {
    Align = General_Exp2((LONGCARD)General_Log2((LONGINT)ElmtSize + ElmtSize - 2));
  }
  return ElmtSize + Align - 1 - (ElmtSize - 1) % Align;
}

void BEGIN_DynArray()
{
  static BOOLEAN has_been_called = FALSE;

  if (!has_been_called) {
    has_been_called = TRUE;

    BEGIN_General();
    BEGIN_Memory();

  }
}
