/*****************************************************************************
 *
 *  xdbx - X Window System interface to the dbx debugger
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of The University of Texas
 *  and Microelectronics and Computer Technology Corporation (MCC) not be 
 *  used in advertising or publicity pertaining to distribution of
 *  the software without specific, written prior permission.  The
 *  University of Texas and MCC makes no representations about the 
 *  suitability of this software for any purpose.  It is provided "as is" 
 *  without express or implied warranty.
 *
 *  THE UNIVERSITY OF TEXAS AND MCC DISCLAIMS ALL WARRANTIES WITH REGARD TO
 *  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TEXAS OR MCC BE LIABLE FOR
 *  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 *  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 *  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  Author:  	Po Cheung
 *  Created:   	April 9, 1990
 *
 *****************************************************************************/

/*  signbitmaps.h
 *
 *    Contain bitmap data for a 48x48 and a 64x64 xdbx icon, and the 
 *	stop sign, execution arrow, up-down arrow, and bomb sign used 
 *	in the source window.
 *
 *  17-nov-92  Added more arrow signs, renamed to "signbitmaps.h",
 *		replaced defines by variables
 */


/* Number of different arrow signs */

#define NUMARROWS 2


/* bitmap data for stop sign */

#define stop_width 16
#define stop_height 16
#define stop_x_hot -1
#define stop_y_hot -1
static char stop_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xd0, 0x01, 0x5c, 0x07,
   0x54, 0x05, 0x54, 0x05, 0x14, 0x04, 0x0c, 0x04, 0x08, 0x04, 0x18, 0x06,
   0xf0, 0x03, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00};


/* Bitmap data for arrow signs */

Dimension arrow_width[NUMARROWS] = {16,16};
Dimension arrow_height[NUMARROWS]= {16,16};
Dimension arrow_x_hot[NUMARROWS] = {-1,-1};
Dimension arrow_y_hot[NUMARROWS] = {-1,-1};
static char arrow_bits[NUMARROWS][32] = {
 { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x07, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x07, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
 { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xff, 0x01, 0xff, 0x03,
   0xff, 0x07, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x07, 0xff, 0x03, 0xff, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
};


/* bitmap data for up-down (outlined arrow) sign */

#define updown_width 16
#define updown_height 16
#define updown_x_hot -1
#define updown_y_hot -1
static char updown_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x06, 0x01, 0x0c, 0x01, 0x0c, 0xff, 0x06, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for bomb sign */

#define bomb_width 16
#define bomb_height 16
static char bomb_bits[] = {
   0x00, 0x00, 0x69, 0x00, 0x94, 0x00, 0x8a, 0x00, 0xc0, 0x01, 0xc5, 0x01,
   0xf0, 0x07, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0d, 0xf8, 0x0d, 0xf8, 0x0d,
   0xf0, 0x06, 0xf0, 0x07, 0xc0, 0x01, 0x00, 0x00};
