/*****************************************************************************
 *
 *  xdbx - X Window System interface to the dbx debugger
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of The University of Texas
 *  and Microelectronics and Computer Technology Corporation (MCC) not be 
 *  used in advertising or publicity pertaining to distribution of
 *  the software without specific, written prior permission.  The
 *  University of Texas and MCC makes no representations about the 
 *  suitability of this software for any purpose.  It is provided "as is" 
 *  without express or implied warranty.
 *
 *  THE UNIVERSITY OF TEXAS AND MCC DISCLAIMS ALL WARRANTIES WITH REGARD TO
 *  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TEXAS OR MCC BE LIABLE FOR
 *  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 *  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 *  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  Author:  	Po Cheung
 *  Created:   	March 10, 1989
 *
 *****************************************************************************/

/*  global.h:
 *
 *    Contain extern declarations of variables and functions.
 *
 *
 *  Changes by Stefan Haenssgen:
 *
 *  07-19-91	Modified to use "swindow" instead of sourceForm, sourceWindow,
 *		 CurrentFile, displayedFile, fileLabel, fileWindow, lineLabel
 *  07-30-91	Furthermore include bomb, arrow, updown, stops and nstops
 *		 in SWindow
 *  07-31-91	Use a_swindow for currently active SWindow; no more global
 *		 "swindow"
 *  08-01-91	Added CreateActiveButton, ActiveButtonCall, ActivateSWindow
 *		 (from swindow.c)
 *		Added swindows[], swindows_num, a_swindow_nr
 *  08-07-91	Added {Add,Remove}SWindow{To,From}File
 *
 *  14-aug-92	Added DirectlyQueryDbx()
 *  02-sep-92	Added concat2() and treeChecksum
 *  17-nov-92	Changed arrow to arrows[] for multiple PCs
 *		New {Display,Remove,Clear}Arrow[s]()
 *  24-nov-92	Added global activation Visualizer actVIS
 *  25-nov-92	Added FetchData() and GetAdress()
 *		Added short definition of VIStype for files without Vis.h
 *		Added act_size & act_compare
 *  26-nov-92	Added act_buffer
 *		Added c_swindow & m_swindow for C/modula source
 *  29-nov-92	Added mline_next
 *  30-nov-92	Added GetValue()
 *		Renamed BuildLineInfos() to BuildMappingInfos()
 *		Introduced PrintVarInfos
 *  01-dec-92	New global vislist for list of active Visualizers, visnum
 *		 for their number
 *
 */

#include "defs.h"

#ifndef Vis_header
typedef struct {		/* For files that don't include Vis.h */
      void	*VISapp_con;	/* XtAppContext */
      void	*VISparent;	/* Widget	*/
      void	*VISvis;	/* visualizer	*/
} VIStype;
#endif

/* calldbx.c */

extern void		calldbx();		/* fork child, exec dbx */

/* command.c */

extern void		 CreateCommandPanel();
extern void		 send_command();
extern char		*get_command();
extern void		 insert_command();
extern void		 delete_command();
extern char		*DirectlyQueryDbx();	/* Get result, no handlers */
extern char		*FetchData();		/* Get data from debuggee */
extern long		 GetAddress();		/* Get address of variable */
extern char		*GetValue();		/* Get value of expression */
extern Widget		 profileW, treeW;	/* Widgets for tree & profile*/
extern long		 treeChecksum;		/* For tree structure dpy */
extern VIStype		*actVIS;		/* Activation Visualizer */
extern long		 act_compare;		/* Activation value */
extern int		 act_size;		/* Size of act.array */
extern long		*act_buffer;		/* Buffer for local act.array*/
extern long		 act_address;		/* Address in debuggee */
extern long		 act_low;		/* Activation index range */
extern long		 act_high;
extern long		 act_index;		/* Index in array */
extern int		 act_context;		/* Context (par/sync) */
extern int		 mline_next;		/* Flag/modula line to change*/
extern VisRec		 vislist[];		/* List of active Visualizers*/
extern int		 visnum;		/* Number of dito */


/* datadpy.c */

extern void		print_handler();	/* printing variables */

/* dbx.c */

extern void		debug_init();		/* initial source display */
extern void 		read_dbx();		/* get data from dbx */
extern void 		write_dbx();		/* send data to dbx */
extern void		query_dbx();		/* ask dbx for info */

/* dialog.c */

extern void		DeleteLine();		/* delete line action proc */
extern void		DeleteWord();		/* delete word action proc */
extern void		CreateDialogWindow();
extern void 		AppendDialogText();	/* append text to buffer */

/* filemenu.c */

extern void		File();			/* file button callback */

/* handler.c */

extern void		TextSetTopPosition();	/* sets topDisplayPosition */
extern void 		AdjustText();		/* adjust display position */
extern void 		exec_handler();		/* run, cont, next, step */
extern void 		done_handler();		/* run, cont, next, step */
extern void 		stop_at_handler();	/* stop at line */
extern void 		stop_in_handler();	/* stop in function */
extern void 		updown_handler();	/* move up/down the stack */
extern void 		delete_handler();	/* delete stop signs */
extern void 		func_handler();		/* display function */
extern void 		file_handler();		/* display file */
extern void 		debug_handler();	/* debug program */
extern void 		cd_handler();		/* change directory */
extern void 		pwd_handler();		/* print working directory */
extern void 		use_handler();		/* update use directory list */
extern void 		search_handler();	/* display searched string */
extern void 		list_handler();		/* list source code */
extern void 		display_handler();	/* show display variables */

/* parser.c */

extern void		parser_init();		/* initialization */
extern void		parse();		/* parse dbx output */
extern void		filter();		/* modify dbx output */

/* signals.c */
extern void		trap_signals();		/* signal handling for xdbx */

/* signs.c */

extern void		signs_init();		/* initilalize routine */
extern void 		DisplayStop();		/* show stop sign */
extern void 		UpdateStops();		/* update position of stops */
extern void 		ClearStops();		/* mark all stops invalid */
extern void 		RemoveStop();		/* undisplay stop sign */
extern void		DisplayArrow();		/* show arrow */
extern void 		UpdateArrows();		/* update positions of arrows*/
extern void		RemoveArrow();		/* undisplay one arrow sign */
extern void		ClearArrows();		/* invalidate all arrows */
extern void 		UpdateUpdown();		/* update position of updown */
extern void 		UpdateBomb();		/* update position of bomb */

/* source.c */

extern void		SelectStart();		/* modified select-start */
extern void		SelectEnd();		/* modified select-end */
extern void		SelectWord();		/* my select word */
extern void		PrintSelection();	/* select variable and print */
extern void		Update();		/* update line label */
extern void		source_init();		/* init routine */
extern void 		CreateSourceWindow();
extern void		SaveDisplayedFileInfo();
extern int 		LoadFile();		/* display source file */
extern int 		LoadCurrentFile();	/* display source file */
extern char		*GetPathname();		/* get full path name of file*/
extern void		MakeDirList();		/* maintain list of dirs */
extern int		CToModulaLine();	/* Convert/map line numbers */
extern int		ModulaToCLine();
extern void		BuildMappingInfos();	/* Build mapping tables */
extern void		PrintLineInfos();	/* Print line mapping table */
extern void		PrintVarInfos();	/* Print var'name mapping */

/* swindow.c */

extern void		ActivateSWindow();	/* Make SWindow active       */
extern SWindow		*CreateSWindow();	/* Create & init new SWindow */
extern void		DeleteSWindow();	/* Close & remove SWindow    */
extern SWindow		*PopupSWindow();	/* Create & popup SWindow    */
extern void		AddSWindowToFile();	/* Update "what's displayed..*/
extern void		RemoveSWindowFromFile();/* ..where" info 	     */

/* utils.c */

extern XawTextPosition	TextGetLastPos();	/* get last pos of text */
extern int 		TextPositionToLine();	/* convert line # to text pos */
extern int		LineToStop_no();	/* convert line # to stop # */
extern void 		DisableWindowResize();  /* do not allow window resize */
extern void 		bell();			/* sound bell */
extern char 		*concat();		/* substring search */
extern char 		*concat2();		/* concat 2 strings */

/* windows.c */

extern void 		CreateSubWindows();	/* all subwindows of xdbx */
extern void 		UpdateFileLabel();	/* update current file name */
extern void 		UpdateLineLabel();	/* update current line num */
extern void 		UpdateMessageWindow();	/* update xdbx message */

/* extern variables */

extern Display		*display;
extern XtAppContext 	app_context;
extern Widget		toplevel, messageWindow, commandWindow, 
                        dialogWindow, searchWindow, separator, displayWindow;

extern Cursor	watch;			/* XC_watch cursor */
extern XdbxResources app_resources;	/* application resources */
extern char	xdbxinit[];		/* initialization filename */
extern char	*dbxprompt;		/* dbx prompt string */
extern char	*xdbxprompt;		/* xdbx prompt string */
extern Boolean	Tstartup;
extern Boolean	debug;


/* SWindow stuff */

extern SWindow  *a_swindow;		/* Info on displayed source text */
					/* (currently active SWindow) */
extern SWindow  *c_swindow;		/* C source */
					/* Corresponding Modula source */
extern SWindow  *m_swindow;		/* Info on displayed source text */
					/* (currently active SWindow) */
extern SWindow	*swindows[MAX_SWINDOWS];/* Array of SWindows */
extern Cardinal	swindows_num;		/* Number of created SWindows */


extern Tokens		Token;		/* token structure */
extern PatternRec       dataPattern[]; 	/* data display pattern */

extern Boolean 	Echo;			/* echo dbx output onto window ? */
extern Boolean	Prompt;			/* command or program input ? */
extern Boolean	Parse;			/* flag for parser */
extern Boolean	FalseSignal;		/* real/false signal ? */
extern Boolean	PopupMode;		/* True if graphical display */
extern int	dbxpid;			/* dbx process id */
extern FILE	*dbxfp;			/* file pointer to dbx process */

/*extern char 	CurrentFile[];		/* string for dbx output */
extern char 	cwd[];			/* current working directory of dbx */

extern Arrow    arrows[];		/* arrow widget and mapped info */
extern Cardinal	narrows;		/* Number of arrows		*/
extern Updown   updown;			/* updown widget and mapped info */
extern Stops    stops[];		/* stop widget and mapped info */
extern Bomb	bomb;			/* bomb widget and mapped info */
extern Cardinal nstops;			/* number of stops */

