/*****************************************************************************
 *
 *  xdbx - X Window System interface to the dbx debugger
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of The University of Texas
 *  and Microelectronics and Computer Technology Corporation (MCC) not be 
 *  used in advertising or publicity pertaining to distribution of
 *  the software without specific, written prior permission.  The
 *  University of Texas and MCC makes no representations about the 
 *  suitability of this software for any purpose.  It is provided "as is" 
 *  without express or implied warranty.
 *
 *  THE UNIVERSITY OF TEXAS AND MCC DISCLAIMS ALL WARRANTIES WITH REGARD TO
 *  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TEXAS OR MCC BE LIABLE FOR
 *  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 *  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 *  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  Author:  	Po Cheung
 *  Created:   	March 10, 1989
 *
 *****************************************************************************/

/*  defs.h
 *
 *    Contain #includes, #defines and typedefs
 *
 *
 *  Changes by Stefan Haenssgen:
 *
 *  07-19-91	Added struct SWindow to support multiple source code windows
 *		(contains information needed for each one)
 *  07-30-91	Introduced DEBUG_OUTPUT
 *  07-31-91	Included pointer to SWindow in file struct
 *  08-01-91	Added activeButton to SWindow
 *  08-02-91	Added popdownButton to SWindow
 *  08-07-91	Added sws[], nsws to FileRec in order to keep track of
 *		 where the file is displayed
 *		Made stops, nstops, arrow, bomb, updown  global again
 *		Moved lines, currentline, topline, bottomline, topposition
 *		 from FileRec to SWindow because it's display relevant only
 *		Added old_topPosition and old_currentline to FileRec
 *		 to remember position when the SWindow displays another file
 *		Added arrow_i, updown_i and bomb_i to SWindow because those
 *		 are SWindow-dependant, not arrow-etc-dependant
 *  02-04-92	Added "VIS_HELP" for help on Visualize useage
 *
 *  07-aug-92	Adapted to X11R5 (removed XtChainTop etc)
 *  14-aug-92	Defined PROFILE_HELP and TREE_HELP
 *		Added stuff to SWindow to make Modula-listings easier
 *		 to be manipulated from xdbx (SWType, OtherSW)
 *		Defined SWTYPE_{C,MODULA} as types for SWindows
 *  17-nov-92	Redefined Arrow to support multiple PCs (& sizes),
 *		Introduced MAXARROWS
 *		Replaced char file[] with char *file in Arrow
 *  19-nov-92	Introduced struct LineInfo for line mapping
 *		Added clines & mlines to FileRec (mappings)
 *		Added FileType to FileRec (analogon to SWType)
 *		Added OtherFile to FileRec to mark corresponding C/Modula src
 *  26-nov-92	Defined LineStack to keep track of nested structures
 *  27-nov-92	Added field Context to line infos
 *  28-nov-92	Added field mline to all sign records, for corr. modula line
 *  30-nov-92	Added VarNameInfo to map variable names
 *		Introduced field varinfos in file record
 *  01-dec-92	Introduced VisRec to contain active Visualizer infos
 *		Includede "Vis.h"
 *  12-mar-93	Added DEBUGFNSOURCE to check if inside DebugFn
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/TextP.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/cursorfont.h>
#include "Vis.h"

/* incompatibility of header file with X11R4 documentation */
/*#define XawChainTop		XtChainTop		   */
/*#define XawChainBottom	XtChainBottom		   */
/*#define XawChainLeft		XtChainLeft		   */
/*#define XawChainRight		XtChainRight		   */

#ifndef AssignMax
#define AssignMax(x, y) 	if ((y) > (x)) x = (y)
#endif
#ifndef AssignMin
#define AssignMin(x, y) 	if ((y) < (x)) x = (y)
#endif

#define LINESIZ         512		/* input line length */
#define MAXNAME         256		/* max identifier length */
#define MAXARGS 	20		/* max number of args */
#define ADD_SIZE 	16		/* # of files added during Realloc */
#define CHARS_PER_LINE  20		/* estimated number of chars per line */
#define ADD_LINES       50		/* # of lines to be added in realloc */
#define NTOKENS		6		/* number of tokens */
#define DEBUGGER      	"dbx"		/* name of executable */
#define XDBXPROMPT  	"msdb > "	/* xdbx prompt string */
#define DELIMITERS	" !%^&*()+=~|;:{},/#<?\"\n\t"

#define MAX_SWINDOWS	32		/* Maximum # of source windows	*/
#define SWTYPE_C	0		/* Types of SWindows		*/
#define SWTYPE_MODULA	1

#define	MAX_VISNUM	5		/* Maximum # of active Visualizers */

#define STOP_AT_HELP	"Please select a line to stop at"
#define STOP_IN_HELP	"Please select a function to stop in"
#define DELETE_HELP	"Please select a stop sign to delete"
#define PRINT_HELP	"Please select an expression to print"
#define UNDISPLAY_HELP	"Please select an expression to undisplay"
#define SEARCH_HELP	"Nothing to search"
#define VIS_HELP	"Please select an array to visualize"
#define PROFILE_HELP	"No Profile information routines present"
#define TREE_HELP	"No Debug Node Tree information routines present"

#define DEBUGFNSOURCE	"DebugFn.c"

#define	LASTCH(s)	(s[strlen(s)-1])
#define	SECLASTCH(s)	(s[strlen(s)-2])

#ifdef SUNOS4
typedef struct dirent 	Directory;
#else
typedef struct direct 	Directory;
#endif


typedef struct {
    Boolean   bell;		/* if True, bell on */
    Boolean   displayWindow;	/* if True, display window on startup */
    String    delimiters;	/* set of delimiters for word selection */
    String    prompt;		/* prompt string for xdbx */

    Pixel     stop_color;	/* color of stop sign */
    Pixel     arrow_color;	/* color of arrow sign */
    Pixel     updown_color;	/* color of updown sign */
    Pixel     bomb_color;	/* color of bomb sign */

    Dimension dataDpyMaxHeight;	/* data display window maximum height */
    Dimension dataDpyMaxWidth;	/* data display window maximum width */

    Boolean   bigicon;		/* xdbx option -bigicon */
    Boolean   debug;		/* xdbx option -debug */

    Boolean   dbxopt_r;		/* dbx option -r */
    Boolean   dbxopt_i;		/* dbx option -i */
    String    includeDir;	/* dbx option -I includeDir */
    Boolean   dbxopt_k;		/* dbx option -k */
    String    cfile;		/* Berkeley  dbx option -c file */
    Boolean   dbxopt_kbd;	/* Sun dbx option -kbd */
    String    fcount;		/* SunOS 4.0 dbx option -f fcount */
    String    startup;		/* SunOS 4.0 dbx option -s startup */
    String    tstartup;		/* SunOS 4.0 dbx option -sr tstartup */
    Boolean   pixie;		/* Mips dbx option -pixie */
} XdbxResources;


/* Line mapping Modula-2* <-> C */

typedef struct {
    int		 Line;			/* Corresponding line		*/
    char	*Function;		/* Name of current function	*/
    char	*File;			/* Name of file			*/
    int		 Type;			/* Type of structure,eg DN_WHILE*/
    int		 Context;		/* Context (normal/sync/par)	*/
} LineInfo;

typedef struct _l_s_ {
    int		 Type;			/* Type of stucture, eg DN_WHILE*/
    int		 Context;		/* Context (normal/sync/par)	*/
    int		 LineFrom;		/* Range of structure		*/
    int		 LineTo;
    struct _l_s_*Up;			/* 1 higher in stack		*/
    struct _l_s_*Down;			/* 1 lower in stack		*/
} LineStack;


/* Variable name mapping */

typedef struct {
    char	*CName;			/* Name of variable in C	*/
    char	*MName;			/* Corresponding name in Modula	*/
    char	*CType;			/* Type of variable in C	*/
    char	*MType;			/* Type of variable in Modula	*/
    int		 CLine;			/* Line of definition in C	*/
    int		 MLine;			/* Corresponding line in Modula	*/
} VarNameInfo;


typedef struct {
    VIStype	*vis;			/* Visualizer pointer		*/
    char	*name;			/* Name of array being shown	*/
    long	 adr;			/* Address of array in debuggee	*/
    char	*array;			/* Our local copy of the array	*/
    int		 len;			/* Number of bytes in the array	*/
} VisRec;

typedef struct _f_r_ {
    char 		*filename;	/* name of file */
    char 		*pathname;	/* full path name of file */
    char 		*buf;		/* buffer holding source file */
    long		filesize;	/* size of file in bytes */
    time_t		mtime;		/* time last modified */
    int			old_currentline;/* where cursor was last time open */
    int			lastline;	/*number of lines in source file */
    XawTextPosition 	*linepos;	/* array of text pos for each newline*/
    XawTextPosition	old_topPosition;/* last topPosition in an SWindow */
    int			nsws;		/* Number of SWindows where displayed*/
    void		*sws[MAX_SWINDOWS];/* Windows where file is displayed*/
    /* this is a SWindow* but the definition would be recursive otherwise! */
    
/* Line mappings (for C & Modula files): */
    LineInfo	**clines;		/* C source lines for M2* src	*/
    LineInfo	**mlines;		/* M2* source lines for C src	*/
    
/* Variable name mappings (dito): */
    VarNameInfo	**varinfos;		/* C <-> M2* variable names	*/
    int		  varinfosnum;		/* Number of such mappings	*/

/* File Type & correspondances */
    int		  FileType;		/* Type of file (Modula, C, ...	*/
    struct _f_r_ *OtherFile;		/* Corresponding Modula/C file	*/
    
} FileRec, *FileRecPtr;

typedef struct {
    char	*mesg;			/* part of matched string */
    unsigned	stop;			/* stop number */
    char 	*func;			/* function name */
    int		line;			/* line number */
    char	*file;			/* file name */
    char	*display;		/* variable display output */
} Tokens;

typedef struct dataDpyList {
    struct dataDpyRec	*dataDpy;
    struct dataDpyList	*next;
} DataDpyList;

typedef struct dataDpyRec {
    int			id;
    Widget              popupshell;             /* parent of popup */
    Widget              popup;                  /* form widget */
    Widget              label;                  /* label widget */
    Widget              dataDpyWindow;          /* window for displaying data*/
    char                *buf;                   /* text buffer */
    int                 buflen;
    XawTextPosition     *linepos;
    int                 numlines;
    int                 maxLineLength;
    int			state;			/* EMPTY, UNUSED, USED */
    struct dataDpyRec	*parent;		/* pointer to parent */
    struct dataDpyList	*childlist;		/* list of children */
} DataDpyRec, *DataDpyRecPtr;

typedef struct {
    char			*pat;		/* regular expression */
    struct re_pattern_buffer	*buf;		/* buffer for compile regex */
    int				reg_token[NTOKENS];	/* register number */
} PatternRec, *PatternRecPtr;

typedef struct commandRec {
    char		*command;
    struct commandRec	*next;
} CommandRec, *CommandRecPtr;

typedef struct {
    char	*file;			/* file associated with		     */
    int	 	line;			/* line number			     */
    int	 	mline;			/* corresp. line number in modula src*/
    char 	func[MAXNAME];		/* function name associated with     */
    int		size;			/* Size of arrow (-> # of PEs there) */
} Arrow;

typedef struct {
    char	file[MAXNAME];		/* file associated with */
    int	 	line;			/* line number */
    int	 	mline;			/* corresp. line number in modula src*/
    char 	func[MAXNAME];		/* function name associated with */
} Updown;

typedef struct {
    char	*file;			/* file associated with */
    int	 	line;			/* line number of stop */
    int	 	mline;			/* corresp. line number in modula src*/
    unsigned    tag;                    /* used in deleting stops */
} Stops;

typedef struct {
    char	file[MAXNAME];		/* file associated with */
    int	 	line;			/* line number */
    int	 	mline;			/* corresp. line number in modula src*/
    char 	func[MAXNAME];		/* function name associated with */
} Bomb;

/* Moved here from signs.c because we need it for an SWindow */

#define MAXSTOPS        256             /* max number of stops		*/
#define MAXARROWS       256             /* max number of PC arrows	*/
#define MAXSIGNS        256             /* max number of signs		*/
#define OFFSET	        2             	/* offset for displaying signs	*/

typedef struct {
    Widget      w;
    Boolean     mapped;
} ArrowSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} UpdownSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} StopSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} BombSign;


/* Support for multiple source windows */

typedef struct s_w_s_ {
    Widget	sourceForm;		/* Parent of text Widget	*/
    Widget	sourceWindow;		/* Source code text Widge	*/
    Widget	fileLabel;		/* Show name of shown file	*/
    Widget	lineLabel;		/* Show current line number	*/
    Widget	activeButton;		/* Window activation button	*/
    Widget	closeButton;		/* Close source window - popdown*/
    Widget	fileWindow;		/* Parent of file&label display	*/
    Widget	popupShell;		/* Popup shell (if popped up)	*/
    Widget	popupPaned;		/* Paned widget for SWindow (if pop) */

    Cardinal	my_number;		/* Number in array		*/
    struct s_w_s_ *OtherSW;		/* Window connected to this one */
    int		SWType;			/* Type, e.g. Modula/C/..-Window*/

    FileRec	*displayedFile;		/* Ptr to table entry of file	*/
					/* that we're displaying	*/
    char	CurrentFile[MAXNAME];	/* Name of current file		*/
    
/* Taken from FileRec: */
    int	 		lines;		/* # of lines on display	*/
    int	 		currentline;	/* line where caret is		*/
    int	 		topline;	/* top line number in the window*/
    int	 		bottomline;	/* bottom line number in window */
    XawTextPosition 	topPosition;	/* top display pos. of buffer	*/
    
/* Taken from signs.c: */
    ArrowSign	arrowsign[MAXSIGNS];
    UpdownSign	updownsign[MAXSIGNS];	/* widgets for signs in this window */
    StopSign	stopsign[MAXSIGNS];
    BombSign 	bombsign[MAXSIGNS];
    
/* Taken from Arrow, Updown and Bomb: */
    Cardinal	updown_i;		/* index to updownsign[]	*/
    Cardinal	bomb_i;			/* index to bombsign[]		*/

} SWindow;


#define DEBUG_OUTPUT 1			/* get some debugging output	*/

