/*
 * VisP.h
 *
 * Private definitions for Array Visualizer
 *
 * Stefan Haenssgen 28-Nov-91
 *
 * Updates :	28-Nov-91  Basic Implementation
 *		28-Dec-91  Structured redesign, formed an ADT out of
 *			    the single data structures
 *		30-Dec-91  Added new Widgets "visselect" and "vs_*"
 *			    for user selection of conditions
 *			   Added "vactive{1,2}" for easy access to
 *			    currently active layers
 *		09-Jan-92  Enhanced the documentation
 *			   Changed the interface: Just one call to
 *			    "visualize()" instead of two calls & X Windows init
 *		10-Jan-92  Added generic comparison function "vcmpfn()" and
 *			    array access function "vaccfn()"
 *			   Added new interface "visualize_userfn()"
 *			   Added vrunning for termination check
 *			   Added "{open,close}_visualizer()" and "VIStype"
 *		16-Jan-92  Renamed functions for easier Modula interfacing:
 *				open_visualizer	   -> OpenVisualizer()
 *				visualize()	   -> Visualize()
 *				visualize_userfn() -> VisualizeUserFn()
 *				close_visualizer   -> CloseVisualizer()
 *		19-Jan-92  Added Widgets for "from-to range": vftomto, vft_*
 *			   Added Values for range: vfromval, vtoval
 *		28-Jan-92  Added support for sockets and fork()ing:
 *			    VISvis  in VIS,
 *			    vforked, vsocketname, vwritesocket  in visual.type
 *			    also: vbindsocket, vreadsocket
 *		29-Jan-92  Updated documentation
 *		30-Jan-92  Also include time.h for selection timeouts
 *			   Added UPDATE_INTERVAL for regual checks on socket
 *		04-Feb-92  Split visual.h into Vis.h (public) and VisP.h
 *			    (private)
 *			   Added vreadoffset for better socket reading
 *			    (wait until data complete before displaying it)
 *		05-Feb-92  Added new sockets for handling commands and
 *			    renamed existing ones. New names:
 *			    v{data,cmd}{bind,read,write}socket
 *			    v{data,cmd}socketname
 *		06-Feb-92  Added vsynced for socket synchronization
 *		08-Feb-92  Added vonewidth for one-dimensional arrays
 *		10-Feb-92  Added vsyncchfn, renamed vsynced to vsyncupdate
 *			    (select synchronization for update / function
 *			    change seperately)
 *			   Changed calls accordingly
 *		16-Apr-92  Added vdispmode for different array display
 *			    modes (b&w, grayscale, color)
 *			   Added statistics (min,max,average) for value-Vis.
 *			   Added vfactorval for quick mapping to display values
 *		01-Jul-92  Added vvarval for variance of array elements
 *		02-Jul-92  Added DEBUGINFO to switch debugging output on/off
 *		22-Jul-92  Added <errno.h>
 *		27-Aug-92  Added "callfn" to support VisualizeActivation()
 *			   Added "vVIS" to point to parent VIStype
 *			   
 *
 */


/* Make sure that the public definitions (extern ...) don't disturb us here */

#define VISUAL_ITSELF


/* Switch output of debugging info on/off */

#undef DEBUGINFO


/* Include necessary stuff for X Windows and display & counter ADTs */

#include "X.h"
#include "display.h"
#include "counter.h"
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/time.h>
#include <errno.h>


/* Maximum number of Dimensions */

#define MAXDIMS 4


/* Update interval for socket-checks when in background mode	*/
/* (in usec)  i.e. 1000 = 1 sec					*/

#define UPDATE_INTERVAL 1000


/* ADT "visualizer" */

typedef struct {

  /* Displayed Array and method of display				*/

  char		 vname[128];	/* Name of array			*/
  void		*vadr;		/* Address of array			*/
  int		 vdims[MAXDIMS];/* Range of Dimensions			*/
  int		 vnumdims;	/* Number of Dimensions			*/
  int		 vtype;		/* Type of array element (int, char,..)	*/
  Boolean	 vusefn;	/* True if user defined functions used	*/
  Boolean	 vuserange;	/* True if from..to range selection used*/
  int		 vactive1,vactive2;/* Currently active section layers	*/
  int		 vonewidth;	/* Width if array is one-dimensional	*/
  int		 vdispmode;	/* Array display mode			*/

  /* Statistics	(for value Visualizer)					*/

  void         *vminval,*vmaxval;/* Minimum & maximum element in array	*/
  double	vavval;		/* Average value in array		*/
  double	vfactorval;	/* Factor for mapping to display value	*/
  double	vvarval;	/* Variance of array elements		*/


  /* User defined functions, data and values for display		*/

  char		 vcmptext[256];	/* Text for comparison display		*/
  int		 vcondition;	/* Condition (V_GREATER etc)		*/
  void		*vcomparison;	/* Data for comparison			*/
  void		*vfromval;	/* Range: value for "from"		*/
  void		*vtoval;	/*        value for "to"		*/
  Boolean	 vfrominfinite;	/* True if "from" is -infinite		*/
  Boolean	 vtoinfinite;	/*         "to"   is +infinite		*/
  Boolean	(*vcmpfn)();	/* Element comparison function		*/
  void		*(*vaccfn)();	/* Array access function		*/
  void		*venvp;		/* Environment data for cmp. function	*/
  long		 venvlen;	/* Length of user data environment	*/
  void		(*vcallfn)();	/* Function to call when mouse clicked	*/


  /* Background operation and sockets					*/

  Boolean	 vforked;	/* True if background process active	*/
  Boolean	 vsyncupdate;	/* True if sync. of array update	*/
  Boolean	 vsyncchfn;	/* True if sync. of function change	*/
  char           vdatasockname[100]; /* Name of data socket to be used	*/
  char           vcmdsockname[100]; /* Name of command socket to be used*/
  int		 vdatawritesock;   /* Socket through which to write data*/
  int		 vdatareadsock;	/*   ... read data			*/
  int		 vdatabindsock;	/*   ... for binding			*/
  int		 vcmdwritesock;	/* Dito for writing commands		*/
  int		 vcmdreadsock;	/*   ... reading commands		*/
  int		 vcmdbindsock;	/*   ... for binding the command socket	*/
  char		*vreadoffset;	/* Offset for reading newly arrived data*/
  int		 vchildproc;	/* Process ID of child (if forked)	*/
  Boolean	 vrunning;	/* True if visualizer is still "alive"	*/

  /* Widgets for the X Windows display					*/

  Widget	 vparent;	/* Parent widget			*/
  Widget	 vispaned;	/* Paned Widget to contain the rest	*/
  Widget	 visshow;	/* Actual positions & values		*/
  Widget	 viscond;	/* Display of comparison condition	*/
  Widget	 visselect;	/* Interactive entry of comparison:	*/
  Widget	 vs_label;	/* - Instructions for user		*/
  Widget	 vs_gtbtn;	/* - Button ">"				*/
  Widget	 vs_eqbtn;	/*          "="				*/
  Widget	 vs_ltbtn;	/*          "<"				*/
  Widget	 vs_type;	/* - Type of value			*/
  Widget	 vs_value;	/* - Value entry			*/
  Widget	 visfromto;	/* From..to range entry:		*/
  Widget	 vft_1;		/* - Instructions part 1		*/
  Widget	 vft_2;		/* - Instructions part 2		*/
  Widget	 vft_from;	/* - Value entry "from"			*/
  Widget	 vft_to;	/* - Value entry "to"			*/
  Widget	 visquit;	/* Guess				*/

  /* Counter and Displayer module					*/

  countertype	*vcounter;	/* Counter ADT				*/
  displaytype   *vdisplay;	/* Display ADT				*/

  /* Link to parent (VIStype !)						*/

  void 		*vVIS;		/* ...to be able to pass this to callfn!*/

} visualizertype;


