/*
 * counter.h
 *
 * Header file for counter.c
 *
 *
 * Stefan Haenssgen 05-20-91
 *
 * Changes:	06-18-91 Event handling functions added
 *			 Reformatted Source
 *		06-26-91 Added detailed decription of functions
 *			 Added "set_counter_text"
 *		07-13-91 Experimentally changed implementation to
 *			 use scrollbars
 *		12-28-91 Added user data for user defineable data
 *		01-09-92 Changed counterbox to counterform (better resizing)
 *
 */



/* Maximum number of counters */

#define MAX_COUNTERS 30


/* Minimum size of one scrollbar */

#define SCROLLBARLENGTH 100


/* structure of one single counter */

typedef struct {
    int     my_number;		/* Number of this counter		*/
    void    *counterset;	/* Set where counter belongs to		*/
				/* "void" because of cyclic declarations!! */
    int     value;		/* Value of counter			*/
    int     min, max;		/* Boundaries				*/
    Boolean active;		/* True if counter is active. Only .	*/
				/* two counters can be active at once!	*/
    Widget  cpaned;		/* Container for buttons		*/
    Widget  cup;		/* Counting up Button			*/
    Widget  cdown;		/* Counting down			*/
    Widget  cscroll;		/* Scrollbar for value entry		*/
    Widget  center;		/* Data entry & display Widget		*/
    Widget  ctoggle;		/* Toggle Widget for des/activation	*/
} onecountertype;


/* Structure of one counter set */

typedef struct {
    int     num_counters;	/* Number of counters in the set	*/
    Widget  parent;		/* Paret widget of this counter		*/
    Widget  counterform;	/* Box widget countaining single counters */
    onecountertype *counters[MAX_COUNTERS];  /* Array of counter-pointers */
    int     lastactive;		/* Least recently activated button	  */
    void    (*changedvalue)();	/* Called when value of counter changes	  */
				/* parameters: (countertype *ct,	  */
				/*              int number, int oldvalue, */
				/*              int newvalue)		  */
				/* number = which of the single counters  */
				/* {old,new}value = value of that counter */
    void    (*changedstate)();	/* Called when state (on/off) changes	  */
				/* parameters: (countertype *ct,	  */
				/*              int number_set		  */
				/*              int number_reset)	  */
				/* number_set = which counter was activated */
				/* number_reset = which was desactivated  */
				/* (states are always changed in pairs !) */
    void    *userdata;		/* Pointer to user defineable data structures*/
} countertype;


/* Structured information for callback routines */

typedef struct {
    countertype *ct;		/* To which counter set we belong	*/
    onecountertype *ot;		/* Which counter we are			*/
    int nr;			/* Our number (ok, it's redundant :)	*/
    int howmuch;		/* How much we want to add to the counter */
} callcountertype;



/* Public functions in counter.c */

#ifndef THIS_IS_COUNTER_C
extern countertype *create_counter();	/* Create one counter instance	*/
extern void         init_counter();	/* Initialize it (bitmaps etc)	*/
extern void         destroy_counter();	/* Destroy one instance		*/
extern void         clear_all_counters(); /* Reset all counters		*/
extern int          get_number();	/* Return number of counters	*/
extern void         set_counter();	/* Set value of one counter	*/
extern void         set_all_counters();	/* Set values of all counters	*/
extern int          get_counter();	/* Get value of one counter	*/
extern void         get_all_counters();	/* Get values of all counters	*/
extern Boolean      get_state();	/* Get state (on/off) of one	*/
extern void         get_all_states();	/* Get states of all counters	*/
extern void	    set_counter_functions();/* Set event handling functions */
extern void         set_counter_text();	/* Set label of one counter	*/
extern void         set_counter_userdata();/* Set pointer to user data	*/
extern void        *get_counter_userdata();/* Return pointer to user data*/
#endif


/* Number of steps with which we want to get through	*/
/* one whole counter range				*/

#define NUMBER_INC 5


/*
 * Detailed description of functions:
 *
 *
 * countertype *create_counter(int num_counters, int *c_min, int *c_max,
 *                             Widget parent)
 *
 *   Creates a set of counters and initializes them. Boundaries of
 *   possible counter values are passed in the c_min and c_max arrays.
 *
 *
 * void init_counter(countertype *ct)
 *
 *   Initializes bitmaps of counter buttons
 *   (Impossible before parent widget is realized - we need its X-display
 *    to create a bitmap! So this function MUST be called AFTER the parent
 *    of the counter widget is realized)
 *
 *
 * void destroy_counter(countertype *ct)
 *
 *   Destroys an instance of a counter set
 *
 *
 * void clear_all_counters(countertype *ct)
 *
 *   Sets all counters in a counter set to the minimum bound
 *
 *
 * int get_number(countertype *ct)
 *
 *   Returns number of counters in one counter structure
 *
 *
 * void set_counter(countertype *ct, int number, int value)
 *
 *   Sets one counter of a set to a specified value. Checking against
 *   boundaries is done, and values are truncated if necessary.
 *
 *
 * void set_all_counters(countertype *ct, int *values)
 *
 *   Sets all counters of a set to a specified value. Boundaries are checked.
 *   Values are passed in the array "values".
 *
 *
 * int get_counter(countertype *ct, int number);
 *
 *   Returns the value of the number-th counter in the counter set
 *
 *
 * void get_all_counters(countertype *ct, int *values)
 *
 *   Writes the actual values of all pointers into the array "values"
 *   (that must be allocated!!)
 *
 *
 * Boolean get_state(countertype *ct, int number)
 *
 *   Returns the state of the number-th counter in the set.
 *   "True" means the counter is active. Only up to two counters in
 *   a set may be active at once
 *
 *
 * void get_all_states(countertype *ct, Boolean *states)
 *
 *   Returns the states of all counters in "states" (which must be
 *   already allocated!).
 *   "True" means the counter is active. Only up to two counters in
 *   a set may be active at once
 *
 *
 * void set_counter_functions(countertype *ct,void (*chval)(),void (*chsta)() )
 *
 *   Sets event handling functions:
 *   chval(countertype *c, int number, int oldvalue, int newvalue)
 *        is called when the value of one counter changes. Parameters:
 *        number          = which of the single counters
 *        {old,new}value  = value of that counter
 *   chsta(countertype *c, int number, Boolean newstate)
 *        is called when the state (on/off) of one counter changes. Parameters:
 *        number          = which of the single counters
 *        newstate        = new state of that counter
 *   If chval of chsta is NULL then no corresponding function is called
 *
 *
 * void set_counter_text(countertype *ct, int nr, char *text)
 *
 *   Sets the label of the active-button of the nr-th counter to "text"
 *
 *
 * void set_counter_userdata(countertype *ct, void *userdata)
 *
 *   Stores a user defineable pointer in the counter data structure
 *   (not used by the counter functions themselves, just user data)
 *
 *
 * void *get_counteruserdata(countertype *ct)
 *
 *   Returns the user defineable pointer
 */
