/*
 * DebugFnV.h
 *
 * Headers for the debug functions, X11 / Visualizer specific stuff
 *
 * Stefan Haenssgen  10-Jul-92
 *
 * Updates:
 *
 *	26-Oct-92	Split into DebugFn.h (basic stuff) + DebugFnV.h
 *			 (X11 / Visualizer specific stuff)
 *	08-Nov-92	Introduced ProfileGraphWidget()
 *	29-Nov-92	Added UpdateProfileGraph(), renamed ProfileGraphWidget
 *			 to ShowGraphWidget
 */

#ifndef DebugFnV_header
#define DebugFnV_header

#include "DebugFn.h"

#include "../Vis/Vis.h"

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

extern char	*_D_TypeString[];	/* Names of types	*/
extern char	*_D_ContextString[];	/* Names of contexts	*/


/* Additional functions available to the user: */



extern Widget	ShowTreeWidget(/*parent*/);	/* Widget containing a tree  */
extern void	UpdateTreeWidget(/*popup*/);	/* Update shown tree	     */

extern Widget	ShowProfileWidget(/*parent*/);	/* Widget with profile infos */
extern void	UpdateProfileWidget(/*popup*/); /* Update shown infos	     */

extern Widget	ShowGraphWidget(/*par,pt*/);	/* Widget with profile graph */
extern void	UpdateGraphWidget(/*pop,pt*/);	/* Update shown graph	     */

extern void	ShowTree();		/* Display debug tree & profile infos*/
					/* (does its own X event loop etc!)  */

extern void	DebugVisualizeActives(  /* Visualize activation values	     */
		   /* AVector,AValue,
		   from,to,name,namelen*/);


#endif /* ifndef DebugFnV_header */
