#ifndef DEFINITION_msScan

/*
 *  Scan Library for Modula-2*
 *
 *  allows for efficient scan operations on
 *  arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 16.10.1992
 */

#include "MSHEADERS.SUN4.h"


/* singular versions */

#define     SScanAddB(x,nx,lx,y,ny,ly)	SScanAddCh(x,nx,lx,y,ny,ly)
extern void SScanAddCh();
extern void SScanAddSC();
extern void SScanAddC();
extern void SScanAddSI();
extern void SScanAddI();
extern void SScanAddR();
extern void SScanAddLR();

#define     SScanAndB(x,nx,lx,y,ny,ly)	SScanAndCh(x,nx,lx,y,ny,ly)
extern void SScanAndCh();
extern void SScanAndSC();
extern void SScanAndC();
extern void SScanAndSI();
extern void SScanAndI();

#define     SScanMaxB(x,nx,lx,y,ny,ly)	SScanMaxCh(x,nx,lx,y,ny,ly)
extern void SScanMaxCh();
extern void SScanMaxSC();
extern void SScanMaxC();
extern void SScanMaxSI();
extern void SScanMaxI();
extern void SScanMaxR();
extern void SScanMaxLR();

#define     SScanMinB(x,nx,lx,y,ny,ly)	SScanMinCh(x,nx,lx,y,ny,ly)
extern void SScanMinCh();
extern void SScanMinSC();
extern void SScanMinC();
extern void SScanMinSI();
extern void SScanMinI();
extern void SScanMinR();
extern void SScanMinLR();

#define     SScanMulB(x,nx,lx,y,ny,ly)	SScanMulCh(x,nx,lx,y,ny,ly)
extern void SScanMulCh();
extern void SScanMulSC();
extern void SScanMulC();
extern void SScanMulSI();
extern void SScanMulI();
extern void SScanMulR();
extern void SScanMulLR();

#define     SScanOrB(x,nx,lx,y,ny,ly)	SScanOrCh(x,nx,lx,y,ny,ly)
extern void SScanOrCh();
extern void SScanOrSC();
extern void SScanOrC();
extern void SScanOrSI();
extern void SScanOrI();

#define     SMaskScanAddB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanAddCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanAddCh();
extern void SMaskScanAddSC();
extern void SMaskScanAddC();
extern void SMaskScanAddSI();
extern void SMaskScanAddI();
extern void SMaskScanAddR();
extern void SMaskScanAddLR();

#define     SMaskScanAndB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanAndCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanAndCh();
extern void SMaskScanAndSC();
extern void SMaskScanAndC();
extern void SMaskScanAndSI();
extern void SMaskScanAndI();

#define     SMaskScanMaxB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanMaxCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanMaxCh();
extern void SMaskScanMaxSC();
extern void SMaskScanMaxC();
extern void SMaskScanMaxSI();
extern void SMaskScanMaxI();
extern void SMaskScanMaxR();
extern void SMaskScanMaxLR();

#define     SMaskScanMinB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanMinCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanMinCh();
extern void SMaskScanMinSC();
extern void SMaskScanMinC();
extern void SMaskScanMinSI();
extern void SMaskScanMinI();
extern void SMaskScanMinR();
extern void SMaskScanMinLR();

#define     SMaskScanMulB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanMulCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanMulCh();
extern void SMaskScanMulSC();
extern void SMaskScanMulC();
extern void SMaskScanMulSI();
extern void SMaskScanMulI();
extern void SMaskScanMulR();
extern void SMaskScanMulLR();

#define     SMaskScanOrB(mask,nm,lm,x,nx,lx,y,ny,ly)	SMaskScanOrCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern void SMaskScanOrCh();
extern void SMaskScanOrSC();
extern void SMaskScanOrC();
extern void SMaskScanOrSI();
extern void SMaskScanOrI();

#define     SSegScanAddB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanAddCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanAddCh();
extern void SSegScanAddSC();
extern void SSegScanAddC();
extern void SSegScanAddSI();
extern void SSegScanAddI();
extern void SSegScanAddR();
extern void SSegScanAddLR();

#define     SSegScanAndB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanAndCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanAndCh();
extern void SSegScanAndSC();
extern void SSegScanAndC();
extern void SSegScanAndSI();
extern void SSegScanAndI();

#define     SSegScanMaxB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanMaxCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanMaxCh();
extern void SSegScanMaxSC();
extern void SSegScanMaxC();
extern void SSegScanMaxSI();
extern void SSegScanMaxI();
extern void SSegScanMaxR();
extern void SSegScanMaxLR();

#define     SSegScanMinB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanMinCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanMinCh();
extern void SSegScanMinSC();
extern void SSegScanMinC();
extern void SSegScanMinSI();
extern void SSegScanMinI();
extern void SSegScanMinR();
extern void SSegScanMinLR();

#define     SSegScanMulB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanMulCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanMulCh();
extern void SSegScanMulSC();
extern void SSegScanMulC();
extern void SSegScanMulSI();
extern void SSegScanMulI();
extern void SSegScanMulR();
extern void SSegScanMulLR();

#define     SSegScanOrB(segs,ns,ls,x,nx,lx,y,ny,ly)	SSegScanOrCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SSegScanOrCh();
extern void SSegScanOrSC();
extern void SSegScanOrC();
extern void SSegScanOrSI();
extern void SSegScanOrI();

#define     SUnivScanAddB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanAddCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanAddCh();
extern void SUnivScanAddSC();
extern void SUnivScanAddC();
extern void SUnivScanAddSI();
extern void SUnivScanAddI();
extern void SUnivScanAddR();
extern void SUnivScanAddLR();

#define     SUnivScanAndB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanAndCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanAndCh();
extern void SUnivScanAndSC();
extern void SUnivScanAndC();
extern void SUnivScanAndSI();
extern void SUnivScanAndI();

#define     SUnivScanMaxB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanMaxCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanMaxCh();
extern void SUnivScanMaxSC();
extern void SUnivScanMaxC();
extern void SUnivScanMaxSI();
extern void SUnivScanMaxI();
extern void SUnivScanMaxR();
extern void SUnivScanMaxLR();

#define     SUnivScanMinB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanMinCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanMinCh();
extern void SUnivScanMinSC();
extern void SUnivScanMinC();
extern void SUnivScanMinSI();
extern void SUnivScanMinI();
extern void SUnivScanMinR();
extern void SUnivScanMinLR();

#define     SUnivScanMulB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanMulCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanMulCh();
extern void SUnivScanMulSC();
extern void SUnivScanMulC();
extern void SUnivScanMulSI();
extern void SUnivScanMulI();
extern void SUnivScanMulR();
extern void SUnivScanMulLR();

#define     SUnivScanOrB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
	    SUnivScanOrCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern void SUnivScanOrCh();
extern void SUnivScanOrSC();
extern void SUnivScanOrC();
extern void SUnivScanOrSI();
extern void SUnivScanOrI();


/* plural versions */

#define		   p_0_SScanAddB(x,nx,lx,y,ny,ly)    p_0_SScanAddCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanAddCh();
extern plural void p_0_SScanAddSC();
extern plural void p_0_SScanAddC();
extern plural void p_0_SScanAddSI();
extern plural void p_0_SScanAddI();
extern plural void p_0_SScanAddR();
extern plural void p_0_SScanAddLR();

#define		   p_0_SScanAndB(x,nx,lx,y,ny,ly)    p_0_SScanAndCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanAndCh();
extern plural void p_0_SScanAndSC();
extern plural void p_0_SScanAndC();
extern plural void p_0_SScanAndSI();
extern plural void p_0_SScanAndI();

#define		   p_0_SScanMaxB(x,nx,lx,y,ny,ly)    p_0_SScanMaxCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanMaxCh();
extern plural void p_0_SScanMaxSC();
extern plural void p_0_SScanMaxC();
extern plural void p_0_SScanMaxSI();
extern plural void p_0_SScanMaxI();
extern plural void p_0_SScanMaxR();
extern plural void p_0_SScanMaxLR();

#define		   p_0_SScanMinB(x,nx,lx,y,ny,ly)    p_0_SScanMinCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanMinCh();
extern plural void p_0_SScanMinSC();
extern plural void p_0_SScanMinC();
extern plural void p_0_SScanMinSI();
extern plural void p_0_SScanMinI();
extern plural void p_0_SScanMinR();
extern plural void p_0_SScanMinLR();

#define		   p_0_SScanMulB(x,nx,lx,y,ny,ly)    p_0_SScanMulCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanMulCh();
extern plural void p_0_SScanMulSC();
extern plural void p_0_SScanMulC();
extern plural void p_0_SScanMulSI();
extern plural void p_0_SScanMulI();
extern plural void p_0_SScanMulR();
extern plural void p_0_SScanMulLR();

#define		   p_0_SScanOrB(x,nx,lx,y,ny,ly)     p_0_SScanOrCh(x,nx,lx,y,ny,ly)
extern plural void p_0_SScanOrCh();
extern plural void p_0_SScanOrSC();
extern plural void p_0_SScanOrC();
extern plural void p_0_SScanOrSI();
extern plural void p_0_SScanOrI();

#define		   p_0_SMaskScanAddB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanAddCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanAddCh();
extern plural void p_0_SMaskScanAddSC();
extern plural void p_0_SMaskScanAddC();
extern plural void p_0_SMaskScanAddSI();
extern plural void p_0_SMaskScanAddI();
extern plural void p_0_SMaskScanAddR();
extern plural void p_0_SMaskScanAddLR();

#define		   p_0_SMaskScanAndB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanAndCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanAndCh();
extern plural void p_0_SMaskScanAndSC();
extern plural void p_0_SMaskScanAndC();
extern plural void p_0_SMaskScanAndSI();
extern plural void p_0_SMaskScanAndI();

#define		   p_0_SMaskScanMaxB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanMaxCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanMaxCh();
extern plural void p_0_SMaskScanMaxSC();
extern plural void p_0_SMaskScanMaxC();
extern plural void p_0_SMaskScanMaxSI();
extern plural void p_0_SMaskScanMaxI();
extern plural void p_0_SMaskScanMaxR();
extern plural void p_0_SMaskScanMaxLR();

#define		   p_0_SMaskScanMinB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanMinCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanMinCh();
extern plural void p_0_SMaskScanMinSC();
extern plural void p_0_SMaskScanMinC();
extern plural void p_0_SMaskScanMinSI();
extern plural void p_0_SMaskScanMinI();
extern plural void p_0_SMaskScanMinR();
extern plural void p_0_SMaskScanMinLR();

#define		   p_0_SMaskScanMulB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanMulCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanMulCh();
extern plural void p_0_SMaskScanMulSC();
extern plural void p_0_SMaskScanMulC();
extern plural void p_0_SMaskScanMulSI();
extern plural void p_0_SMaskScanMulI();
extern plural void p_0_SMaskScanMulR();
extern plural void p_0_SMaskScanMulLR();

#define		   p_0_SMaskScanOrB(mask,nm,lm,x,nx,lx,y,ny,ly) \
		   p_0_SMaskScanOrCh(mask,nm,lm,x,nx,lx,y,ny,ly)
extern plural void p_0_SMaskScanOrCh();
extern plural void p_0_SMaskScanOrSC();
extern plural void p_0_SMaskScanOrC();
extern plural void p_0_SMaskScanOrSI();
extern plural void p_0_SMaskScanOrI();

#define		   p_0_SSegScanAddB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanAddCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanAddCh();
extern plural void p_0_SSegScanAddSC();
extern plural void p_0_SSegScanAddC();
extern plural void p_0_SSegScanAddSI();
extern plural void p_0_SSegScanAddI();
extern plural void p_0_SSegScanAddR();
extern plural void p_0_SSegScanAddLR();

#define		   p_0_SSegScanAndB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanAndCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanAndCh();
extern plural void p_0_SSegScanAndSC();
extern plural void p_0_SSegScanAndC();
extern plural void p_0_SSegScanAndSI();
extern plural void p_0_SSegScanAndI();

#define		   p_0_SSegScanMaxB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanMaxCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanMaxCh();
extern plural void p_0_SSegScanMaxSC();
extern plural void p_0_SSegScanMaxC();
extern plural void p_0_SSegScanMaxSI();
extern plural void p_0_SSegScanMaxI();
extern plural void p_0_SSegScanMaxR();
extern plural void p_0_SSegScanMaxLR();

#define		   p_0_SSegScanMinB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanMinCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanMinCh();
extern plural void p_0_SSegScanMinSC();
extern plural void p_0_SSegScanMinC();
extern plural void p_0_SSegScanMinSI();
extern plural void p_0_SSegScanMinI();
extern plural void p_0_SSegScanMinR();
extern plural void p_0_SSegScanMinLR();

#define		   p_0_SSegScanMulB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanMulCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanMulCh();
extern plural void p_0_SSegScanMulSC();
extern plural void p_0_SSegScanMulC();
extern plural void p_0_SSegScanMulSI();
extern plural void p_0_SSegScanMulI();
extern plural void p_0_SSegScanMulR();
extern plural void p_0_SSegScanMulLR();

#define		   p_0_SSegScanOrB(segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SSegScanOrCh(segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SSegScanOrCh();
extern plural void p_0_SSegScanOrSC();
extern plural void p_0_SSegScanOrC();
extern plural void p_0_SSegScanOrSI();
extern plural void p_0_SSegScanOrI();

#define		   p_0_SUnivScanAddB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanAddCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanAddCh();
extern plural void p_0_SUnivScanAddSC();
extern plural void p_0_SUnivScanAddC();
extern plural void p_0_SUnivScanAddSI();
extern plural void p_0_SUnivScanAddI();
extern plural void p_0_SUnivScanAddR();
extern plural void p_0_SUnivScanAddLR();

#define		   p_0_SUnivScanAndB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanAndCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanAndCh();
extern plural void p_0_SUnivScanAndSC();
extern plural void p_0_SUnivScanAndC();
extern plural void p_0_SUnivScanAndSI();
extern plural void p_0_SUnivScanAndI();

#define		   p_0_SUnivScanMaxB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanMaxCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanMaxCh();
extern plural void p_0_SUnivScanMaxSC();
extern plural void p_0_SUnivScanMaxC();
extern plural void p_0_SUnivScanMaxSI();
extern plural void p_0_SUnivScanMaxI();
extern plural void p_0_SUnivScanMaxR();
extern plural void p_0_SUnivScanMaxLR();

#define		   p_0_SUnivScanMinB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanMinCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanMinCh();
extern plural void p_0_SUnivScanMinSC();
extern plural void p_0_SUnivScanMinC();
extern plural void p_0_SUnivScanMinSI();
extern plural void p_0_SUnivScanMinI();
extern plural void p_0_SUnivScanMinR();
extern plural void p_0_SUnivScanMinLR();

#define		   p_0_SUnivScanMulB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanMulCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanMulCh();
extern plural void p_0_SUnivScanMulSC();
extern plural void p_0_SUnivScanMulC();
extern plural void p_0_SUnivScanMulSI();
extern plural void p_0_SUnivScanMulI();
extern plural void p_0_SUnivScanMulR();
extern plural void p_0_SUnivScanMulLR();

#define		   p_0_SUnivScanOrB(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly) \
		   p_0_SUnivScanOrCh(mask,nm,lm,segs,ns,ls,x,nx,lx,y,ny,ly)
extern plural void p_0_SUnivScanOrCh();
extern plural void p_0_SUnivScanOrSC();
extern plural void p_0_SUnivScanOrC();
extern plural void p_0_SUnivScanOrSI();
extern plural void p_0_SUnivScanOrI();


#endif
#define DEFINITION_msScan
