#ifndef DEFINITION_msReduce

/*
 *  Reduction Library for Modula-2*
 *
 *  allows for efficient reduction operations on
 *  arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 15.10.1992
 */

#include "MSHEADERS.SUN4.h"


/* singular versions */

#define          SReduceAddB(x,nx,lx)	SReduceAddCh(x,nx,lx)
extern CHAR	 SReduceAddCh();
extern SHORTCARD SReduceAddSC();
extern LONGCARD	 SReduceAddC();
extern SHORTINT	 SReduceAddSI();
extern LONGINT	 SReduceAddI();
extern REAL	 SReduceAddR();
extern LONGREAL	 SReduceAddLR();

#define          SReduceAndB(x,nx,lx)	SReduceAndCh(x,nx,lx)
extern CHAR	 SReduceAndCh();
extern SHORTCARD SReduceAndSC();
extern LONGCARD	 SReduceAndC();
extern SHORTINT	 SReduceAndSI();
extern LONGINT	 SReduceAndI();

#define          SReduceMaxB(x,nx,lx)	SReduceMaxCh(x,nx,lx)
extern CHAR	 SReduceMaxCh();
extern SHORTCARD SReduceMaxSC();
extern LONGCARD	 SReduceMaxC();
extern SHORTINT	 SReduceMaxSI();
extern LONGINT	 SReduceMaxI();
extern REAL	 SReduceMaxR();
extern LONGREAL	 SReduceMaxLR();

#define          SReduceMinB(x,nx,lx)	SReduceMinCh(x,nx,lx)
extern CHAR	 SReduceMinCh();
extern SHORTCARD SReduceMinSC();
extern LONGCARD	 SReduceMinC();
extern SHORTINT	 SReduceMinSI();
extern LONGINT	 SReduceMinI();
extern REAL	 SReduceMinR();
extern LONGREAL	 SReduceMinLR();

#define          SReduceMulB(x,nx,lx)	SReduceMulCh(x,nx,lx)
extern CHAR	 SReduceMulCh();
extern SHORTCARD SReduceMulSC();
extern LONGCARD	 SReduceMulC();
extern SHORTINT	 SReduceMulSI();
extern LONGINT	 SReduceMulI();
extern REAL	 SReduceMulR();
extern LONGREAL	 SReduceMulLR();

#define          SReduceOrB(x,nx,lx)	SReduceOrCh(x,nx,lx)
extern CHAR	 SReduceOrCh();
extern SHORTCARD SReduceOrSC();
extern LONGCARD	 SReduceOrC();
extern SHORTINT	 SReduceOrSI();
extern LONGINT	 SReduceOrI();

#define          SMaskReduceAddB(x,nx,lx)	SMaskReduceAddCh(x,nx,lx)
extern CHAR	 SMaskReduceAddCh();
extern SHORTCARD SMaskReduceAddSC();
extern LONGCARD	 SMaskReduceAddC();
extern SHORTINT	 SMaskReduceAddSI();
extern LONGINT	 SMaskReduceAddI();
extern REAL	 SMaskReduceAddR();
extern LONGREAL	 SMaskReduceAddLR();

#define          SMaskReduceAndB(x,nx,lx)	SMaskReduceAndCh(x,nx,lx)
extern CHAR	 SMaskReduceAndCh();
extern SHORTCARD SMaskReduceAndSC();
extern LONGCARD	 SMaskReduceAndC();
extern SHORTINT	 SMaskReduceAndSI();
extern LONGINT	 SMaskReduceAndI();

#define          SMaskReduceMaxB(x,nx,lx)	SMaskReduceMaxCh(x,nx,lx)
extern CHAR	 SMaskReduceMaxCh();
extern SHORTCARD SMaskReduceMaxSC();
extern LONGCARD	 SMaskReduceMaxC();
extern SHORTINT	 SMaskReduceMaxSI();
extern LONGINT	 SMaskReduceMaxI();
extern REAL	 SMaskReduceMaxR();
extern LONGREAL	 SMaskReduceMaxLR();

#define          SMaskReduceMinB(x,nx,lx)	SMaskReduceMinCh(x,nx,lx)
extern CHAR	 SMaskReduceMinCh();
extern SHORTCARD SMaskReduceMinSC();
extern LONGCARD	 SMaskReduceMinC();
extern SHORTINT	 SMaskReduceMinSI();
extern LONGINT	 SMaskReduceMinI();
extern REAL	 SMaskReduceMinR();
extern LONGREAL	 SMaskReduceMinLR();

#define          SMaskReduceMulB(x,nx,lx)	SMaskReduceMulCh(x,nx,lx)
extern CHAR	 SMaskReduceMulCh();
extern SHORTCARD SMaskReduceMulSC();
extern LONGCARD	 SMaskReduceMulC();
extern SHORTINT	 SMaskReduceMulSI();
extern LONGINT	 SMaskReduceMulI();
extern REAL	 SMaskReduceMulR();
extern LONGREAL	 SMaskReduceMulLR();

#define          SMaskReduceOrB(x,nx,lx)		SMaskReduceOrCh(x,nx,lx)
extern CHAR	 SMaskReduceOrCh();
extern SHORTCARD SMaskReduceOrSC();
extern LONGCARD	 SMaskReduceOrC();
extern SHORTINT	 SMaskReduceOrSI();
extern LONGINT	 SMaskReduceOrI();


/* plural versions */

#define		   	p_0_SReduceAddB(x,nx,lx)    p_0_SReduceAddCh(x,nx,lx)
extern plural CHAR	p_0_SReduceAddCh();
extern plural SHORTCARD p_0_SReduceAddSC();
extern plural LONGCARD	p_0_SReduceAddC();
extern plural SHORTINT	p_0_SReduceAddSI();
extern plural LONGINT	p_0_SReduceAddI();
extern plural REAL	p_0_SReduceAddR();
extern plural LONGREAL	p_0_SReduceAddLR();

#define			p_0_SReduceAndB(x,nx,lx)    p_0_SReduceAndCh(x,nx,lx)
extern plural CHAR	p_0_SReduceAndCh();
extern plural SHORTCARD p_0_SReduceAndSC();
extern plural LONGCARD	p_0_SReduceAndC();
extern plural SHORTINT	p_0_SReduceAndSI();
extern plural LONGINT	p_0_SReduceAndI();

#define			p_0_SReduceMaxB(x,nx,lx)	   p_0_SReduceMaxCh(x,nx,lx)
extern plural CHAR	p_0_SReduceMaxCh();
extern plural SHORTCARD p_0_SReduceMaxSC();
extern plural LONGCARD	p_0_SReduceMaxC();
extern plural SHORTINT	p_0_SReduceMaxSI();
extern plural LONGINT	p_0_SReduceMaxI();
extern plural REAL	p_0_SReduceMaxR();
extern plural LONGREAL	p_0_SReduceMaxLR();

#define			p_0_SReduceMinB(x,nx,lx)    p_0_SReduceMinCh(x,nx,lx)
extern plural CHAR	p_0_SReduceMinCh();
extern plural SHORTCARD p_0_SReduceMinSC();
extern plural LONGCARD	p_0_SReduceMinC();
extern plural SHORTINT	p_0_SReduceMinSI();
extern plural LONGINT	p_0_SReduceMinI();
extern plural REAL	p_0_SReduceMinR();
extern plural LONGREAL	p_0_SReduceMinLR();

#define			p_0_SReduceMulB(x,nx,lx)    p_0_SReduceMulCh(x,nx,lx)
extern plural CHAR	p_0_SReduceMulCh();
extern plural SHORTCARD p_0_SReduceMulSC();
extern plural LONGCARD	p_0_SReduceMulC();
extern plural SHORTINT	p_0_SReduceMulSI();
extern plural LONGINT	p_0_SReduceMulI();
extern plural REAL	p_0_SReduceMulR();
extern plural LONGREAL	p_0_SReduceMulLR();

#define			p_0_SReduceOrB(x,nx,lx)     p_0_SReduceOrCh(x,nx,lx)
extern plural CHAR	p_0_SReduceOrCh();
extern plural SHORTCARD p_0_SReduceOrSC();
extern plural LONGCARD	p_0_SReduceOrC();
extern plural SHORTINT	p_0_SReduceOrSI();
extern plural LONGINT	p_0_SReduceOrI();

#define		   	p_0_SMaskReduceAddB(x,nx,lx)	p_0_SMaskReduceAddCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceAddCh();
extern plural SHORTCARD p_0_SMaskReduceAddSC();
extern plural LONGCARD	p_0_SMaskReduceAddC();
extern plural SHORTINT	p_0_SMaskReduceAddSI();
extern plural LONGINT	p_0_SMaskReduceAddI();
extern plural REAL	p_0_SMaskReduceAddR();
extern plural LONGREAL	p_0_SMaskReduceAddLR();

#define			p_0_SMaskReduceAndB(x,nx,lx)	p_0_SMaskReduceAndCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceAndCh();
extern plural SHORTCARD p_0_SMaskReduceAndSC();
extern plural LONGCARD	p_0_SMaskReduceAndC();
extern plural SHORTINT	p_0_SMaskReduceAndSI();
extern plural LONGINT	p_0_SMaskReduceAndI();

#define			p_0_SMaskReduceMaxB(x,nx,lx)	p_0_SMaskReduceMaxCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceMaxCh();
extern plural SHORTCARD p_0_SMaskReduceMaxSC();
extern plural LONGCARD	p_0_SMaskReduceMaxC();
extern plural SHORTINT	p_0_SMaskReduceMaxSI();
extern plural LONGINT	p_0_SMaskReduceMaxI();
extern plural REAL	p_0_SMaskReduceMaxR();
extern plural LONGREAL	p_0_SMaskReduceMaxLR();

#define			p_0_SMaskReduceMinB(x,nx,lx)	p_0_SMaskReduceMinCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceMinCh();
extern plural SHORTCARD p_0_SMaskReduceMinSC();
extern plural LONGCARD	p_0_SMaskReduceMinC();
extern plural SHORTINT	p_0_SMaskReduceMinSI();
extern plural LONGINT	p_0_SMaskReduceMinI();
extern plural REAL	p_0_SMaskReduceMinR();
extern plural LONGREAL	p_0_SMaskReduceMinLR();

#define			p_0_SMaskReduceMulB(x,nx,lx)	p_0_SMaskReduceMulCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceMulCh();
extern plural SHORTCARD p_0_SMaskReduceMulSC();
extern plural LONGCARD	p_0_SMaskReduceMulC();
extern plural SHORTINT	p_0_SMaskReduceMulSI();
extern plural LONGINT	p_0_SMaskReduceMulI();
extern plural REAL	p_0_SMaskReduceMulR();
extern plural LONGREAL	p_0_SMaskReduceMulLR();

#define			p_0_SMaskReduceOrB(x,nx,lx)	p_0_SMaskReduceOrCh(x,nx,lx)
extern plural CHAR	p_0_SMaskReduceOrCh();
extern plural SHORTCARD p_0_SMaskReduceOrSC();
extern plural LONGCARD	p_0_SMaskReduceOrC();
extern plural SHORTINT	p_0_SMaskReduceOrSI();
extern plural LONGINT	p_0_SMaskReduceOrI();


#endif
#define DEFINITION_msReduce
