/*
 * msRusage.c	Get resource utilization
 *
 * Stefan Haenssgen 26-oct-92
 *
 * 26-oct-92	First implementation: Rusage{UTime, STime, Time, Swaps, Size}()
 *		Added RusagePfaults()
 *		Added RusageStart() and delta functions (RusageD{Time,.....}())
 *
 */

#include "msRusage.SUN3.h"

struct rusage RusageStruct;	/* Global variable for delta-timings	*/


void RusageStart()		/* Remember current rusage for deltas	*/
{
    getrusage(RUSAGE_SELF, &RusageStruct);
};


/******************************** Routines for measuring total values	*/


double RusageUTime()		/* Return spent user time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) ru.ru_utime.tv_sec +
	    (double) ru.ru_utime.tv_usec / (double) 1e6
	  );
}


double RusageSTime()		/* Return spent system time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) ru.ru_stime.tv_sec +
	    (double) ru.ru_stime.tv_usec / (double) 1e6
	  );
}


double RusageTime()		/* Return user + system time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) (ru.ru_utime.tv_sec  + ru.ru_stime.tv_sec)  +
	    (double) (ru.ru_utime.tv_usec + ru.ru_stime.tv_usec) / (double) 1e6
	   );
}


long RusageSwaps()		/* Return number of swaps		*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) ru.ru_nswap );
}


long RusageSize()		/* Return maximum process size in bytes	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) (ru.ru_maxrss * getpagesize()) );
}


long RusagePfaults()		/* Return number of page faults with I/O*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) ru.ru_majflt );
}


/******************************** Routines for measuring delta values	*/
/******************************** (RusageStart() must have been called!)*/


double RusageDUTime()		/* Return spent user time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) (ru.ru_utime.tv_sec  - RusageStruct.ru_utime.tv_sec) +
	    (double) (ru.ru_utime.tv_usec - RusageStruct.ru_utime.tv_usec)
	              / (double) 1e6
	  );
}


double RusageDSTime()		/* Return spent system time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) (ru.ru_stime.tv_sec  - RusageStruct.ru_stime.tv_sec) +
	    (double) (ru.ru_stime.tv_usec - RusageStruct.ru_stime.tv_usec)
		      / (double) 1e6
	  );
}


double RusageDTime()		/* Return user + system time in seconds	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (double) (ru.ru_utime.tv_sec - RusageStruct.ru_utime.tv_sec +
	              ru.ru_stime.tv_sec - RusageStruct.ru_stime.tv_sec) +
	    (double) (ru.ru_utime.tv_usec - RusageStruct.ru_utime.tv_usec +
	              ru.ru_stime.tv_usec - RusageStruct.ru_stime.tv_usec)
	              / (double) 1e6
	   );
}


long RusageDSwaps()		/* Return number of swaps		*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) (ru.ru_nswap - RusageStruct.ru_nswap) );
}


long RusageDSize()		/* Return maximum process size in bytes	*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) ((ru.ru_maxrss - RusageStruct.ru_maxrss) * getpagesize()) );
}


long RusageDPfaults()		/* Return number of page faults with I/O*/
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( (long) (ru.ru_majflt - RusageStruct.ru_majflt) );
}
