
/********************************************************************
 ********************************************************************
 ******                                                        ******
 ******  Enumeration Library for Modula-2*                     ******
 ******                                                        ******
 ******  allows for efficient enumeration operations on        ******
 ******  arbitrarily large and distributed arrays              ******
 ******                                                        ******
 ******  C/MPL implementation by Ernst A. Heinz                ******
 ******                                                        ******
 ******  Last change:  March 25, 1994                          ******
 ******                                                        ******
 ********************************************************************
 ********************************************************************/

#include "msEnum.SUN3.h"


/********************************************************************
 ********************************************************************
 *******             MASKED ENUMERATION ROUTINES              *******
 ********************************************************************
 ********************************************************************/

/*
 *  generic template for masked enumeration routines
 */

#define MaskEnumFunc(FuncName,elemType,initVal)	\
    void					\
    FuncName(mask, nm, lm, x, nx, lx)		\
    register BOOLEAN *mask;			\
    LONGCARD nm, lm;				\
    register elemType *x;			\
    register LONGCARD nx;			\
    LONGCARD lx;				\
    {						\
      register elemType num;			\
						\
      if (nx!=nm) return;	 		\
						\
      num = initVal;				\
      for (; nx>0; nx--, mask++, x++)		\
        if (*mask)				\
	  *x = num++;				\
    }


/*****************************************
 *****  masked enumeration routines  *****
 *****************************************/

MaskEnumFunc( SMaskEnumCh, CHAR,      '\0' )
MaskEnumFunc( SMaskEnumSC, SHORTCARD, 0    )
MaskEnumFunc( SMaskEnumC,  CARDINAL,  0    )
MaskEnumFunc( SMaskEnumSI, SHORTINT,  0    )
MaskEnumFunc( SMaskEnumI,  INTEGER,   0    )
MaskEnumFunc( SMaskEnumR,  REAL,      0.0  )
MaskEnumFunc( SMaskEnumLR, LONGREAL,  0.0  )


/********************************************************************
 ********************************************************************
 *******            SEGMENTED ENUMERATION ROUTINES            *******
 ********************************************************************
 ********************************************************************/

/*
 *  generic template for segmented enumeration routines
 */

#define SegEnumFunc(FuncName,elemType,initVal)	\
    void					\
    FuncName(segs, ns, ls, x, nx, lx)		\
    BOOLEAN *segs;				\
    LONGCARD ns, ls;				\
    elemType *x;				\
    register LONGCARD nx;			\
    LONGCARD lx;				\
    {						\
      register BOOLEAN *segp;			\
      register elemType *xp;			\
      register elemType num;			\
      register BOOLEAN seg_flag;		\
						\
      if (nx!=ns) return;			\
						\
      seg_flag = FALSE;				\
      segp = segs;				\
      xp = x;					\
      num = initVal;				\
      for (; nx>0; nx--, segp++, xp++) {	\
	*xp = num++;				\
	if (*segp) {				\
	  num = initVal;			\
	  seg_flag = TRUE;			\
	}					\
      };					\
						\
      if (!seg_flag) return;			\
						\
      segp = segs;				\
      xp = x;					\
      for (; num!=initVal; segp++, xp++) {	\
	*xp += num;				\
	if (*segp)				\
	  num = initVal;			\
      }						\
    }


/********************************************
 *****  segmented enumeration routines  *****
 ********************************************/

SegEnumFunc( SSegEnumCh, CHAR,      '\0' )
SegEnumFunc( SSegEnumSC, SHORTCARD, 0    )
SegEnumFunc( SSegEnumC,  CARDINAL,  0    )
SegEnumFunc( SSegEnumSI, SHORTINT,  0    )
SegEnumFunc( SSegEnumI,  INTEGER,   0    )
SegEnumFunc( SSegEnumR,  REAL,      0.0  )
SegEnumFunc( SSegEnumLR, LONGREAL,  0.0  )


/********************************************************************
 ********************************************************************
 *******            UNIVERSAL ENUMERATION ROUTINES            *******
 ********************************************************************
 ********************************************************************/

/*
 *  generic template for universal enumeration routines
 */

#define UnivEnumFunc(FuncName,elemType,initVal)		\
    void						\
    FuncName(mask, nm, lm, segs, ns, ls, x, nx, lx)	\
    BOOLEAN *mask;					\
    LONGCARD nm, lm;					\
    BOOLEAN *segs;					\
    LONGCARD ns, ls;					\
    elemType *x;					\
    register LONGCARD nx;				\
    LONGCARD lx;					\
    {							\
      register BOOLEAN *maskp, *segp;			\
      register elemType *xp;				\
      register elemType num;				\
      register BOOLEAN seg_flag;			\
							\
      if (nm!=ns || nm!=nx) return;			\
							\
      seg_flag = FALSE;					\
      maskp = mask;					\
      segp = segs;					\
      xp = x;						\
      num = initVal;					\
      for (; nx>0; nx--, maskp++, segp++, xp++)		\
        if (*maskp) {					\
	  *xp = num++;					\
	  if (*segp) {					\
	    num = initVal;				\
	    seg_flag = TRUE;				\
	  }						\
	};						\
							\
      if (!seg_flag) return;				\
							\
      maskp = mask;					\
      segp = segs;					\
      xp = x;						\
      for (; num!=initVal; maskp++, segp++, xp++)	\
        if (*maskp) {					\
	  *xp += num;					\
	  if (*segp)					\
	    num = initVal;				\
	}						\
    }


/********************************************
 *****  universal enumeration routines  *****
 ********************************************/

UnivEnumFunc( SUnivEnumCh, CHAR,      '\0' )
UnivEnumFunc( SUnivEnumSC, SHORTCARD, 0    )
UnivEnumFunc( SUnivEnumC,  CARDINAL,  0    )
UnivEnumFunc( SUnivEnumSI, SHORTINT,  0    )
UnivEnumFunc( SUnivEnumI,  INTEGER,   0    )
UnivEnumFunc( SUnivEnumR,  REAL,      0.0  )
UnivEnumFunc( SUnivEnumLR, LONGREAL,  0.0  )
