FOREIGN MODULE msFIO;

(*
 *  File I/O Library for Modula-2*
 *
 *
 *  Modula-2* interface by Hendrik Mager, Thomas Gauweiler
 *
 *  C implementation by Hendrik Mager, Thomas Gauweiler
 *
 *  26.02.1993	created
 *  17.02.1994	Std channels corrected
 *)


FROM SYSTEM IMPORT ADDRESS;


TYPE
  File = ADDRESS;     (* File handler type *)

CONST
   EOF = -1;

VAR
  StdInput	: File;
  StdOutput	: File;
  StdError	: File;



PROCEDURE FEOF (F: File): BOOLEAN;
(* this procedure returns an non zero number when EOF has previously been
   detected reading the named input straem associated with File 'F'. otherwise
   zero.
   Unless cleared by ClearError () the EOF indication lasts until the stram
   is closed, however operations which attempt to raed from the straem will ignore
   the current state  of the EOF indication.
 *)

PROCEDURE FError (F:File): LONGINT;
(* this procedure returns non-zero when an error has occured reading from or
   writing to the file 'F', otherwise zero. Unless cleared by ClearError the error
   indication lasts un5til the straem associated with the file 'F' is closed.
 *)

PROCEDURE ClearError (F:File);
(* this procedure resets the error indication and EOF indication to zero
   on the stream associated with the file 'F'
 *)


PROCEDURE Close (F: File);
(* this procedure closes an open File, after that it isnot any longer
   available for use
 *)

PROCEDURE Create (Name: ARRAY OF CHAR): File;
(* Create and open a new File *)

PROCEDURE Erase (Name: ARRAY OF CHAR);
(* This procedure deletes a File form the disk *)

PROCEDURE Exists (Name: ARRAY OF CHAR): BOOLEAN;
(* This procedure checks if the File 'Name' exists. Returns TRUE if so,
   otherwise FALSE
 *)


PROCEDURE Flush (F: File);
(* For buffered Files the Flush procedure writes the contents of the
   current buffer to disk. In error case EoF is set to TRUE otherwise
   it is set to FALSE.
 *)

PROCEDURE Open (Name: ARRAY OF CHAR): File;
(* this procedure opens an existing  File specified by 'Name',
   if it fails return value -1 *)

PROCEDURE OpenRead (Name: ARRAY OF CHAR): File;
(* this procedure opens an existing File 'Name' for reading
   if it fails returnvalue -1 *)

PROCEDURE Seek (F: File; Pos: LONGCARD):LONGINT;
(* this procedure repositions the File handler, so that the next
   I/O operation will occur at a different place in the File.
   return value is number of bytes from the beginning of the file
   or -1 if it fails
 *)

PROCEDURE FGetPos (F: File): LONGINT;
(* this procedure returns the current position of the File handler
   in File 'F', failing returnvalue = -1
 *)

PROCEDURE FSize (F: File): LONGINT;
(* this procedure returns the current size of the File 'F'
   failing returnvalue -1 *)

(* read routines *)

PROCEDURE FRdBin (F: File; Buf: ADDRESS (* ARRAY OF BYTE *); n: LONGCARD);
(* read a binary straem of length 'n' into the buffer 'buf'
   from File 'F'
   this is done with type ADDRESS because we donot support the
   type ARRAY OF BYTE.
 *)

(* Read simple types *)
PROCEDURE FRdB (F: File): BOOLEAN;
  (* read File 'F' until input in ['f','F','t','T'],
     return true if input in ['t','T'] *)
PROCEDURE FRdCh (F: File): CHAR;
  (* read character from File 'F' *)
PROCEDURE FRdC (F: File): LONGCARD;
  (* read (long) cardinal  from File 'F' *)
PROCEDURE FRdH (F: File): LONGCARD;
  (* read hexadecimal number from File 'F'
     and return its (long) cardinal value *)
PROCEDURE FRdO (F: File): LONGCARD;
  (* read octal number from File 'F' and return its (long cardinal value*)
PROCEDURE FRdI (F: File): LONGINT;
  (* read (long) integer from File 'F' *)
PROCEDURE FRdLn (F: File); PROCEDURE FRdNl (F: File);
  (* read  from File 'F' until newline chracyer is detected *)
PROCEDURE FRdR (F: File): LONGREAL;
  (* read (long) real from File 'F' *)
PROCEDURE FRdS (F: File; VAR str: ARRAY OF CHAR);
  (* read string from File 'F' *)


(* write routines *)

PROCEDURE FWrBin (F: File; Buf: ADDRESS (* ARRAY OF BYTE *); n: LONGCARD);
(* write a binary straem of length 'n' beginning at Address 'buf'
   to File 'F'
   this is done with type ADDRESS because we donot support the
   type ARRAY OF BYTE.
 *)

(* write simple types *)
PROCEDURE FWrB (F: File; B: BOOLEAN);
  (* write File F until input in ['f','F','t','T'],
     return true if input in ['t','T'] *)
PROCEDURE FWrCh (F: File; Ch: CHAR);
  (* write charcter from File 'F' *)
PROCEDURE FWrI (F: File; I: LONGINT; w:SHORTINT);
  (* write (long) integer to File 'F' *)
PROCEDURE FWrC (F: File; C: LONGCARD; w: SHORTINT);
  (* write (long) cardinal  to File 'F' *)
PROCEDURE FWrH (F: File; H: LONGCARD; w: SHORTINT);
  (* write hexadecimal number to File 'F' *)
PROCEDURE FWrO (F: File; O: LONGCARD; w: SHORTINT);
  (* write octal number to File 'F' *)
PROCEDURE FWrE( F: File; R: LONGREAL; w: SHORTINT; prec: SHORTCARD );
  (* write (long) real value in exponential format *)
PROCEDURE FWrR (F: File; R: LONGREAL; w: SHORTINT; prec: SHORTCARD );
  (* write (long) real value in fixed point format to File 'F' *)
PROCEDURE FWrF( F: File; R: LONGREAL; w: SHORTINT; prec: SHORTCARD; exp: BOOLEAN );
  (* write (long) real value in fixed point or exponential format to File 'F' *)
PROCEDURE FWrS (F: File; VAR str: ARRAY OF CHAR);
  (* write string to File 'F' *)
PROCEDURE FWrLn (F: File); PROCEDURE FWrNl (F: File);
  (* write  newline charcter to File 'F' *)

  
END msFIO.
