
/*
 *  Easy Timer Library for Modula-2*
 *
 *  "TimerElapsed" returns the user time since the last
 *  call to "TimerStart" measured in seconds
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change:  29.03.1994
 */

#include "msTimer.MIPS.h"
#include <sys/time.h>
#include <sys/resource.h>


static struct rusage  msTimerStruct;


void TimerStart()
{
  getrusage(RUSAGE_SELF, &msTimerStruct);
}


LONGREAL TimerElapsed()
{
    struct rusage	ru;

    getrusage(RUSAGE_SELF,&ru);

    return( ((double) 1e6 * (double) (ru.ru_utime.tv_sec  - msTimerStruct.ru_utime.tv_sec) +
	     (double) (ru.ru_utime.tv_usec - msTimerStruct.ru_utime.tv_usec))
            / (double) 1e6
	  );
}
